/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.content.maven.MavenContentFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.maven.MavenMetadataRebuildFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenUploadHandlerSupport;
import org.sonatype.nexus.repository.maven.VersionPolicy;
import org.sonatype.nexus.repository.maven.internal.Maven2MavenPathParser;
import org.sonatype.nexus.repository.maven.internal.MavenPomGenerator;
import org.sonatype.nexus.repository.maven.internal.VersionPolicyValidator;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlobPayload;

@Named(value="maven2")
@Singleton
public class MavenUploadHandler
extends MavenUploadHandlerSupport {
    @Inject
    public MavenUploadHandler(Maven2MavenPathParser parser, @Named(value="maven2") @Named(value="maven2") VariableResolverAdapter variableResolverAdapter, ContentPermissionChecker contentPermissionChecker, VersionPolicyValidator versionPolicyValidator, MavenPomGenerator mavenPomGenerator, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(parser, variableResolverAdapter, contentPermissionChecker, versionPolicyValidator, mavenPomGenerator, uploadDefinitionExtensions, true);
    }

    @Override
    protected UploadResponse getUploadResponse(Repository repository, ComponentUpload componentUpload, String basePath) throws IOException {
        MavenUploadHandlerSupport.ContentAndAssetPathResponseData responseData = this.createAssets(repository, basePath, componentUpload.getAssetUploads());
        this.maybeGeneratePom(repository, componentUpload, basePath, responseData);
        this.updateMetadata(repository, responseData.getCoordinates());
        return new UploadResponse(responseData.getContent(), responseData.getAssetPaths().stream().map(assetPath -> StringUtils.prependIfMissing((String)assetPath, (CharSequence)"/", (CharSequence[])new CharSequence[0])).collect(Collectors.toList()));
    }

    private void updateMetadata(Repository repository, MavenPath.Coordinates coordinates) {
        if (coordinates != null) {
            ((MavenMetadataRebuildFacet)repository.facet(MavenMetadataRebuildFacet.class)).rebuildMetadata(coordinates.getGroupId(), coordinates.getArtifactId(), coordinates.getVersion(), false, false);
        } else {
            this.log.debug("Not updating metadata.xml files since coordinate could not be retrieved from path");
        }
    }

    @Override
    protected Content doPut(ImportFileConfiguration configuration) throws IOException {
        Repository repository = configuration.getRepository();
        MavenPath mavenPath = this.parser.parsePath(configuration.getAssetName());
        File content = configuration.getFile();
        Path contentPath = content.toPath();
        MavenContentFacet contentFacet = (MavenContentFacet)repository.facet(MavenContentFacet.class);
        String contentType = Files.probeContentType(contentPath);
        Throwable throwable = null;
        Object var9_10 = null;
        try (TempBlob blob = contentFacet.blobs().ingest(contentPath, contentType, MavenPath.HashType.ALGORITHMS, configuration.isHardLinkingEnabled());){
            return this.doPut(repository, mavenPath, (Payload)new TempBlobPayload(blob, contentType));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected Content doPut(Repository repository, MavenPath mavenPath, Payload payload) throws IOException {
        MavenContentFacet mavenFacet = (MavenContentFacet)repository.facet(MavenContentFacet.class);
        Content asset = mavenFacet.put(mavenPath, payload);
        this.putChecksumFiles(mavenFacet, mavenPath, asset);
        return asset;
    }

    @Override
    protected VersionPolicy getVersionPolicy(Repository repository) {
        return ((MavenContentFacet)repository.facet(MavenContentFacet.class)).getVersionPolicy();
    }

    @Override
    protected TempBlob createTempBlob(Repository repository, PartPayload payload) {
        return ((MavenContentFacet)repository.facet(MavenContentFacet.class)).blobs().ingest((Payload)payload, MavenPath.HashType.ALGORITHMS);
    }

    private void putChecksumFiles(MavenContentFacet facet, MavenPath path, Content content) throws IOException {
        DateTime dateTime = (DateTime)content.getAttributes().require("last_modified", DateTime.class);
        for (Map.Entry<String, String> e : this.getChecksumsFromContent(content).entrySet()) {
            Optional<HashAlgorithm> hashAlgorithm = HashAlgorithm.getHashAlgorithm((String)e.getKey()).filter(MavenPath.HashType.ALGORITHMS::contains);
            if (!hashAlgorithm.isPresent()) continue;
            Content c = new Content((Payload)new StringPayload(e.getValue(), "text/plain"));
            c.getAttributes().set("last_modified", (Object)dateTime);
            facet.put(path.hash(MavenPath.HashType.valueOf(e.getKey().toUpperCase())), (Payload)c);
        }
    }

    private Map<String, String> getChecksumsFromContent(Content content) {
        return Optional.ofNullable((Asset)content.getAttributes().get(Asset.class)).flatMap(Asset::blob).map(AssetBlob::checksums).orElse(Collections.emptyMap());
    }
}

