/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore.maven.internal.orient;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.blobstore.restore.maven.internal.orient.MavenRestoreBlobData;
import org.sonatype.nexus.blobstore.restore.orient.OrientBaseRestoreBlobStrategy;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.orient.maven.OrientMavenFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;

@FeatureFlag(name="nexus.orient.enabled")
@Priority(value=0x7FFFFFFF)
@Named(value="maven2")
@Singleton
public class OrientMavenRestoreBlobStrategy
extends OrientBaseRestoreBlobStrategy<MavenRestoreBlobData> {
    private final MavenPathParser mavenPathParser;

    @Inject
    public OrientMavenRestoreBlobStrategy(MavenPathParser mavenPathParser, NodeAccess nodeAccess, RepositoryManager repositoryManager, DryRunPrefix dryRunPrefix) {
        super(nodeAccess, repositoryManager, dryRunPrefix);
        this.mavenPathParser = (MavenPathParser)Preconditions.checkNotNull((Object)mavenPathParser);
    }

    protected MavenRestoreBlobData createRestoreData(RestoreBlobData blobData) {
        return new MavenRestoreBlobData(blobData, this.mavenPathParser.parsePath(blobData.getBlobName()));
    }

    protected boolean canAttemptRestore(@Nonnull MavenRestoreBlobData data) {
        MavenPath mavenPath = data.getMavenPath();
        RestoreBlobData blobData = data.getBlobData();
        Repository repository = blobData.getRepository();
        if (mavenPath.getCoordinates() == null && !this.mavenPathParser.isRepositoryMetadata(mavenPath)) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("Skipping blob in repository named {}, because no maven coordinates found for blob named {} in blob store named {} and the blob not maven metadata", new Object[]{repository.getName(), blobData.getBlobName(), blobData.getBlobStore().getBlobStoreConfiguration().getName()});
            }
            return false;
        }
        Optional mavenFacet = repository.optionalFacet(OrientMavenFacet.class);
        if (!mavenFacet.isPresent()) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("Skipping as Maven Facet not found on repository: {}", (Object)repository.getName());
            }
            return false;
        }
        return true;
    }

    @Nonnull
    protected List<HashAlgorithm> getHashAlgorithms() {
        return MavenPath.HashType.ALGORITHMS;
    }

    protected String getAssetPath(@Nonnull MavenRestoreBlobData data) {
        return data.getMavenPath().getPath();
    }

    @TransactionalTouchBlob
    protected boolean assetExists(@Nonnull MavenRestoreBlobData data) throws IOException {
        return ((OrientMavenFacet)data.getBlobData().getRepository().facet(OrientMavenFacet.class)).get(data.getMavenPath()) != null;
    }

    protected boolean componentRequired(@Nonnull MavenRestoreBlobData data) throws IOException {
        MavenPath path = data.getMavenPath();
        return !this.mavenPathParser.isRepositoryIndex(path) && !this.mavenPathParser.isRepositoryMetadata(path);
    }

    protected Query getComponentQuery(@Nonnull MavenRestoreBlobData data) {
        MavenPath.Coordinates coordinates = data.getMavenPath().getCoordinates();
        if (coordinates != null) {
            return Query.builder().where("group").eq((Object)coordinates.getGroupId()).and("name").eq((Object)coordinates.getArtifactId()).and("version").eq((Object)coordinates.getVersion()).build();
        }
        return null;
    }

    @TransactionalStoreMetadata
    protected void createAssetFromBlob(@Nonnull AssetBlob assetBlob, @Nonnull MavenRestoreBlobData data) throws IOException {
        ((OrientMavenFacet)data.getBlobData().getRepository().facet(OrientMavenFacet.class)).put(data.getMavenPath(), assetBlob, null);
    }

    protected Repository getRepository(@Nonnull MavenRestoreBlobData data) {
        return data.getBlobData().getRepository();
    }
}

