/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumDirectory;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmParser;

public final class YumPathUtils {
    public static final String REPOMD_FILE = "repomd.xml";
    public static final String REPOMD_ASC_FILE = "repomd.xml.asc";
    public static final String COMPS_FILE = "comps.xml";
    public static final String REPOMD_PATH = "repodata/repomd.xml";
    public static final String REPOMD_ASC_PATH = "repodata/repomd.xml.asc";
    public static final String ASC_REGEX = ".*[xX][mM][lL]\\.[aA][sS][cC]";
    public static final String RPM_EXTENSION_REGEX = ".*[dD]?[rR][pP][mM]";
    public static final String XML_REGEX = ".*[xX][mM][lL]";
    public static final String XML_GZ_REGEX = ".*[xX][mM][lL]\\.?[gG]?[zZ]?";
    public static final String YAML_GZ_REGEX = ".*[yY][aA][mM][lL]\\.?[gG]?[zZ]?";
    private static final String REPODATA_FOR_CMA_REGEX = ".*repodata/.*";
    public static final Pattern REPODATA_PATTERN = Pattern.compile(".*/repodata/.*");
    public static final Pattern REPODATA_MATCHER = Pattern.compile(".*repodata/.*");
    public static final Pattern REPOMD_ASC_MATCHER = Pattern.compile(".*repodata/.*repomd.*[xX][mM][lL]\\.[aA][sS][cC]");
    public static final Pattern REPOMD_MATCHER = Pattern.compile(".*repodata/.*repomd.*[xX][mM][lL]");
    public static final Pattern COMPS_MATCHER = Pattern.compile(".*repodata/.*comps.*[xX][mM][lL]\\.?[gG]?[zZ]?");
    public static final Pattern MODULES_MATCHER = Pattern.compile(".*repodata/.*.*modules\\..*[yY][aA][mM][lL]\\.?[gG]?[zZ]?");
    public static final Pattern RPM_MATCHER = Pattern.compile(".*[dD]?[rR][pP][mM]");
    private static final String REPODATA = "repodata";

    public static TokenMatcher.State matcherState(Context context) {
        return (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
    }

    public static String name(TokenMatcher.State matcherState) {
        return YumPathUtils.match(matcherState, "name");
    }

    public static String extension(TokenMatcher.State state) {
        return YumPathUtils.match(state, "extension");
    }

    public static String buildAssetPath(TokenMatcher.State matcherState) {
        String path = YumPathUtils.path(matcherState);
        String name = YumPathUtils.name(matcherState);
        String extension = YumPathUtils.extension(matcherState);
        String pathName = YumPathUtils.buildUriPath(path, name);
        return String.valueOf(pathName) + (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)extension) ? "." + extension : "");
    }

    public static String extractFullVersion(String path, InputStream inputStream) {
        return new YumRpmParser().parse(inputStream, path).getFullVersion();
    }

    public static String buildMetadataFilePath(String checksum, String type) {
        return String.format("repodata/%s-%s.xml.gz", checksum, type);
    }

    public static String repodataPath(@Nullable YumDirectory directory) {
        String basePath = directory == null ? "" : directory.getName();
        return YumPathUtils.getRepodataPath(basePath);
    }

    public static String extractDirectoryFromMetadataPath(String path) {
        if (!path.contains("/repodata")) {
            return "";
        }
        return path.substring(0, path.indexOf("/repodata"));
    }

    public static Optional<String> extractDirectoryAtDepth(String name, Integer repodataDepth) {
        int index = StringUtils.ordinalIndexOf((String)name, (String)"/", (int)repodataDepth);
        if (index >= 0) {
            return Optional.of(name.substring(0, index));
        }
        return Optional.empty();
    }

    public static String appendPath(@Nullable String basePath, @Nullable String suffix) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)basePath) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)suffix)) {
            return "";
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)suffix)) {
            return basePath;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)basePath)) {
            return suffix;
        }
        return YumPathUtils.buildUriPath(basePath, suffix);
    }

    public static String getRepomdPath(String basePath) {
        Preconditions.checkNotNull((Object)basePath);
        return YumPathUtils.buildUriPath(basePath, REPODATA, REPOMD_FILE);
    }

    public static String getRepodataPath(String basePath) {
        Preconditions.checkNotNull((Object)basePath);
        return YumPathUtils.buildUriPath(basePath, REPODATA);
    }

    private static String buildUriPath(@Nullable String first, String ... more) {
        String basePath = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)first) ? String.valueOf(first) + "/" : "";
        basePath = String.valueOf(basePath) + Joiner.on((String)"/").join((Object[])more);
        return basePath.replaceAll("/+", "/");
    }

    private static String path(TokenMatcher.State state) {
        return YumPathUtils.match(state, "path").replaceAll("^/", "");
    }

    private static String match(TokenMatcher.State state, String name) {
        Preconditions.checkNotNull((Object)state);
        return (String)Preconditions.checkNotNull((Object)((String)state.getTokens().get(name)));
    }

    private YumPathUtils() {
    }
}

