/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.sonatype.nexus.repository.rest.api.AbstractGroupRepositoriesApiResource;
import org.sonatype.nexus.repository.rest.api.model.GroupRepositoryApiRequest;
import org.sonatype.nexus.repository.yum.rest.YumGroupRepositoryApiRequest;
import org.sonatype.nexus.validation.Validate;

@Api(value="Repository Management")
public abstract class YumGroupRepositoriesApiResource
extends AbstractGroupRepositoriesApiResource<YumGroupRepositoryApiRequest> {
    @ApiOperation(value="Create Yum group repository")
    @ApiResponses(value={@ApiResponse(code=201, message="Repository created"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions")})
    @POST
    @RequiresAuthentication
    @Validate
    public Response createRepository(YumGroupRepositoryApiRequest request) {
        return super.createRepository((GroupRepositoryApiRequest)request);
    }

    @ApiOperation(value="Update Yum group repository")
    @ApiResponses(value={@ApiResponse(code=204, message="Repository updated"), @ApiResponse(code=400, message="Bad request"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions")})
    @PUT
    @RequiresAuthentication
    @Path(value="/{repositoryName}")
    @Validate
    public Response updateRepository(YumGroupRepositoryApiRequest request, @ApiParam(value="Name of the repository to update") @PathParam(value="repositoryName") String repositoryName) {
        return super.updateRepository((GroupRepositoryApiRequest)request, repositoryName);
    }
}

