/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.orient.internal.proxy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Headers;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.internal.gpg.YumSigningFacet;
import org.sonatype.nexus.repository.yum.internal.metadata.CompressedTempBlob;
import org.sonatype.nexus.repository.yum.internal.metadata.RepomdProcessor;
import org.sonatype.nexus.repository.yum.internal.metadata.YumAbsoluteUrlRemover;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;
import org.sonatype.nexus.repository.yum.orient.OrientYumFacet;
import org.sonatype.nexus.repository.yum.orient.internal.database.OrientYumQueryComponent;
import org.sonatype.nexus.repository.yum.orient.internal.metadata.OrientRepomdChecksumAndSizeUpdater;
import org.sonatype.nexus.repository.yum.utils.TempBlobConverter;
import org.sonatype.nexus.repository.yum.utils.YumFacetUtils;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;
import org.sonatype.nexus.transaction.UnitOfWork;
import org.w3c.dom.Document;

@Named
public class OrientYumProxyFacetImpl
extends ProxyFacetSupport {
    private static final String REPODATA_PATH = "repodata/";
    public static final String RHUI_SIGNATURE_HEADER = "X-RHUI-SIGNATURE";
    public static final String RHUI_ID_HEADER = "X-RHUI-ID";
    private static final ImmutableSet<String> CHARS_TO_ENCODE = ImmutableSet.of((Object)"^");
    private final RepomdProcessor repomdProcessor;
    private final TempBlobConverter tempBlobConverter;
    private final YumAbsoluteUrlRemover yumAbsoluteUrlRemover;
    private final OrientYumQueryComponent orientYumQueryComponent;
    private OrientYumFacet yumFacet;
    private final OrientRepomdChecksumAndSizeUpdater checksumUpdater;

    @Inject
    public OrientYumProxyFacetImpl(RepomdProcessor repomdProcessor, TempBlobConverter tempBlobConverter, YumAbsoluteUrlRemover yumAbsoluteUrlRemover, OrientYumQueryComponent orientYumQueryComponent, OrientRepomdChecksumAndSizeUpdater checksumUpdater) {
        this.repomdProcessor = (RepomdProcessor)((Object)Preconditions.checkNotNull((Object)((Object)repomdProcessor)));
        this.tempBlobConverter = (TempBlobConverter)Preconditions.checkNotNull((Object)tempBlobConverter);
        this.yumAbsoluteUrlRemover = (YumAbsoluteUrlRemover)((Object)Preconditions.checkNotNull((Object)((Object)yumAbsoluteUrlRemover)));
        this.orientYumQueryComponent = (OrientYumQueryComponent)((Object)Preconditions.checkNotNull((Object)((Object)orientYumQueryComponent)));
        this.checksumUpdater = (OrientRepomdChecksumAndSizeUpdater)((Object)Preconditions.checkNotNull((Object)((Object)checksumUpdater)));
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.yumFacet = (OrientYumFacet)this.facet(OrientYumFacet.class);
    }

    protected Content doGet(Context context, Content staleContent) throws IOException {
        YumSigningFacet yumSigningFacet = (YumSigningFacet)this.facet(YumSigningFacet.class);
        Optional<Content> metadataSignature = yumSigningFacet.maybeSignRepoMetadata(context, this.getRepository());
        if (metadataSignature.isPresent()) {
            return metadataSignature.get();
        }
        return super.doGet(context, staleContent);
    }

    @Nullable
    protected Content getCachedContent(Context context) throws IOException {
        return this.yumFacet.getAssetAsContent(YumPathUtils.buildAssetPath(YumPathUtils.matcherState(context)));
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        TokenMatcher.State matcherState = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String assetPath = YumPathUtils.buildAssetPath(matcherState);
        if (assetKind == AssetKind.RPM) {
            return this.putRPM(assetPath, content);
        }
        return this.putMetadata(assetPath, content, assetKind, context);
    }

    private Content putMetadata(String assetPath, Content content, AssetKind assetKind, Context context) throws IOException {
        this.clearRepodataIfRepomdAssetKind(assetKind, assetPath);
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content.openInputStream(), YumMetadataUtils.HASH_ALGORITHMS);){
            return this.processAndSaveMetadata(assetPath, tempBlob, (Payload)content, assetKind, context);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content putRPM(String assetPath, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content.openInputStream(), YumMetadataUtils.HASH_ALGORITHMS);){
            return this.yumFacet.storeRpm(assetPath, (InputStreamSupplier)tempBlob, (Payload)content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content processAndSaveMetadata(String assetPath, TempBlob metadataContent, Payload payload, AssetKind assetKind, Context context) throws IOException {
        if (assetKind.equals((Object)AssetKind.REPOMD)) {
            return this.processRepomd(assetPath, metadataContent, payload, assetKind, context);
        }
        if (YumFacetUtils.isPrimary(assetPath, assetKind)) {
            return this.processPrimary(assetPath, metadataContent, payload, assetKind);
        }
        return this.yumFacet.storeMetadata(assetPath, metadataContent, payload, assetKind);
    }

    private Content processRepomd(String assetPath, TempBlob metadataContent, Payload payload, AssetKind assetKind, Context context) {
        try {
            Document repomdXml = this.tempBlobConverter.toDocument(metadataContent);
            this.repomdProcessor.process(repomdXml, path -> this.fetchMetadata(path, this.getRepository(), context));
            Throwable throwable = null;
            Object var8_10 = null;
            try (TempBlob newMetadataContent = this.tempBlobConverter.toTempBlob(repomdXml, this.getRepository());){
                return this.yumFacet.storeMetadata(assetPath, newMetadataContent, payload, assetKind);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    protected Content processPrimary(String assetPath, TempBlob metadataContent, Payload payload, AssetKind assetKind) throws IOException {
        AttributesMap attributes = new AttributesMap();
        if (this.yumAbsoluteUrlRemover.containsAbsoluteUrl(metadataContent, assetPath)) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (CompressedTempBlob tempBlob = this.yumAbsoluteUrlRemover.removeAbsoluteUrls(metadataContent, assetPath, this.getRepository());){
                if (tempBlob.isModified()) {
                    attributes.set("modified", (Object)true);
                    attributes.set("open-sha1", (Object)tempBlob.getDecompressedHashes().get(HashAlgorithm.SHA1).toString());
                    attributes.set("open-sha256", (Object)tempBlob.getDecompressedHashes().get(HashAlgorithm.SHA256).toString());
                    attributes.set("open-sha512", (Object)tempBlob.getDecompressedHashes().get(HashAlgorithm.SHA512).toString());
                    attributes.set("open-md5", (Object)tempBlob.getDecompressedHashes().get(HashAlgorithm.MD5).toString());
                    attributes.set("open-size", (Object)tempBlob.getDecompressedSize());
                    return this.yumFacet.storeMetadata(assetPath, tempBlob.getTempBlob(), payload, assetKind, attributes);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return this.yumFacet.storeMetadata(assetPath, metadataContent, payload, assetKind, attributes);
    }

    @Nullable
    private Content fetchMetadata(String path, Repository repository, Context context) {
        String directory = YumPathUtils.extractDirectoryFromMetadataPath(context.getRequest().getPath());
        String requestPath = YumPathUtils.appendPath(directory, path);
        Request mappingRequest = new Request.Builder().action("GET").path(StringUtils.prependIfMissing((String)requestPath, (CharSequence)"/", (CharSequence[])new CharSequence[0])).build();
        try {
            Response response = ((ViewFacet)repository.facet(ViewFacet.class)).dispatch(mappingRequest, context);
            int status = response.getStatus().getCode();
            if (status != 200) {
                this.log.warn("Failed to fetch metadata file for path {} and repository {}. Received status code {}", new Object[]{path, repository.getName(), status});
            }
            return (Content)response.getPayload();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @TransactionalDeleteBlob
    protected void clearRepodataIfRepomdAssetKind(AssetKind assetKind, String assetPath) {
        if (assetKind == AssetKind.REPOMD) {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Iterable<Asset> metadataAssets = this.orientYumQueryComponent.findRepodataAssets(tx, this.getRepository());
            for (Asset metadataAsset : metadataAssets) {
                if (!this.isAssetInSameFolderAsRepomd(assetPath, metadataAsset.name())) continue;
                tx.deleteAsset(metadataAsset);
            }
        }
    }

    private boolean isAssetInSameFolderAsRepomd(String repomdPath, String assetName) {
        String prefix = repomdPath.substring(0, repomdPath.indexOf(REPODATA_PATH) + REPODATA_PATH.length());
        String metadataName = assetName;
        return metadataName.startsWith(prefix);
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        this.setCacheInfo(content, cacheInfo);
    }

    @TransactionalTouchMetadata
    public void setCacheInfo(Content content, CacheInfo cacheInfo) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)tx.findBucket(this.getRepository()), (Content)content);
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent Yum asset {}", content.getAttributes().require(Asset.class));
            return;
        }
        this.log.debug("Updating cacheInfo of {} to {}", (Object)asset, (Object)cacheInfo);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        tx.saveAsset(asset);
    }

    protected CacheController getCacheController(Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        return (CacheController)Preconditions.checkNotNull((Object)this.cacheControllerHolder.get(assetKind.getCacheType()));
    }

    protected String getUrl(Context context) {
        return context.getRequest().getPath().substring(1);
    }

    protected String encodeUrl(String url) throws UnsupportedEncodingException {
        String encodedUrl = url;
        for (String ch : CHARS_TO_ENCODE) {
            encodedUrl = encodedUrl.replace(ch, URLEncoder.encode(ch, "UTF-8"));
        }
        return encodedUrl;
    }

    protected HttpResponse execute(Context context, HttpClient client, HttpRequestBase request) throws IOException {
        Headers headers = context.getRequest().getHeaders();
        this.copyHeaderIfPresent(request, headers, RHUI_SIGNATURE_HEADER);
        this.copyHeaderIfPresent(request, headers, RHUI_ID_HEADER);
        return super.execute(context, client, request);
    }

    private void copyHeaderIfPresent(HttpRequestBase request, Headers headers, String headerName) {
        if (headers.contains(headerName)) {
            this.log.debug("Adding header {} from client", (Object)headerName);
            request.addHeader(headerName, headers.get(headerName));
        }
    }
}

