/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.orient.internal.metadata;

import com.google.common.hash.HashCode;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.yum.internal.metadata.RepomdChecksumAndSizeUpdater;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.sonatype.nexus.repository.yum.utils.YumFacetUtils;

@Singleton
@Named
public class OrientRepomdChecksumAndSizeUpdater
extends RepomdChecksumAndSizeUpdater {
    @Override
    protected String getSize(Content primaryXml) {
        return Long.toString(this.asset(primaryXml).size());
    }

    @Override
    protected Map getAttributes(Content primaryXml) {
        return (Map)this.asset(primaryXml).attributes().get("yum");
    }

    @Override
    protected String getChecksum(YumMetadata yumMetadata, Content primaryXml) {
        return Optional.ofNullable(yumMetadata.getChecksum()).map(checksum -> this.asset(primaryXml).getChecksum(YumFacetUtils.hashAlgorithmByName(checksum))).map(HashCode::toString).orElse(null);
    }

    private Asset asset(Content primaryXml) {
        return (Asset)primaryXml.getAttributes().get("org.sonatype.nexus.repository.storage.Asset");
    }
}

