/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.orient.internal.metadata;

import java.io.IOException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.internal.metadata.MetadataSignatureStorage;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;
import org.sonatype.nexus.repository.yum.orient.OrientYumFacet;

@Named(value="orient")
@Singleton
public class OrientMetadataStorage
implements MetadataSignatureStorage {
    @Override
    public Content get(Repository repository, String metadataPath) throws IOException {
        return ((OrientYumFacet)repository.facet(OrientYumFacet.class)).getAssetAsContent(metadataPath);
    }

    @Override
    public Content save(Repository repository, String metadataPath, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        OrientYumFacet yumFacet = (OrientYumFacet)repository.facet(OrientYumFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content.openInputStream(), YumMetadataUtils.HASH_ALGORITHMS);){
            return yumFacet.storeMetadata(metadataPath, tempBlob, (Payload)content, AssetKind.REPOMD_ASC);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

