/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.orient.internal.group;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.cache.RepositoryCacheInvalidationService;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.group.GroupFacetImpl;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.PathPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataFile;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupFacet;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupMerger;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRepomdCreator;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRepomdParser;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRequest;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadataType;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;
import org.sonatype.nexus.repository.yum.orient.OrientYumFacet;
import org.sonatype.nexus.repository.yum.orient.internal.database.OrientYumQueryComponent;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;
import org.sonatype.nexus.transaction.UnitOfWork;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
@Facet.Exposed
public class OrientYumGroupFacetImpl
extends GroupFacetImpl
implements YumGroupFacet {
    private static final String REPOMD_FILE = "repomd.xml";
    private static final String REPODATA = "repodata";
    private final YumGroupRepomdCreator groupRepomdCreator;
    private final YumGroupMerger groupMerger;
    private final YumGroupRepomdParser groupRepomdParser;
    private final OrientYumQueryComponent orientYumQueryComponent;
    private OrientYumFacet yumFacet;

    @Inject
    public OrientYumGroupFacetImpl(RepositoryManager repositoryManager, ConstraintViolationFactory constraintViolationFactory, @Named(value="group") @Named(value="group") Type groupType, YumGroupRepomdCreator groupRepomdCreator, YumGroupMerger groupMerger, YumGroupRepomdParser groupRepomdParser, OrientYumQueryComponent orientYumQueryComponent, RepositoryCacheInvalidationService repositoryCacheInvalidationService) {
        super(repositoryManager, constraintViolationFactory, groupType, repositoryCacheInvalidationService);
        this.groupRepomdCreator = (YumGroupRepomdCreator)Preconditions.checkNotNull((Object)groupRepomdCreator);
        this.groupMerger = (YumGroupMerger)Preconditions.checkNotNull((Object)groupMerger);
        this.groupRepomdParser = (YumGroupRepomdParser)Preconditions.checkNotNull((Object)groupRepomdParser);
        this.orientYumQueryComponent = (OrientYumQueryComponent)((Object)Preconditions.checkNotNull((Object)((Object)orientYumQueryComponent)));
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.yumFacet = (OrientYumFacet)this.facet(OrientYumFacet.class);
    }

    @Override
    @Nullable
    public Content buildRepomd(String path, Map<Repository, InputStreamSupplier> repositoriesResponseMap, Context context, Optional<String> etag) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull(repositoriesResponseMap);
        Preconditions.checkNotNull((Object)context);
        if (repositoriesResponseMap.isEmpty()) {
            this.log.debug("Unable to create metadata for repository {}. Members had no metadata to merge.", (Object)context.getRepository().getName());
            return null;
        }
        this.log.info("Creating latest metadata by merging metadata of group members for repository {}", (Object)context.getRepository().getName());
        List<YumMetadataFile> metadataCollection = Collections.emptyList();
        Map<YumMetadataType, List<YumGroupRequest>> repodataFiles = this.groupRepomdParser.parse(repositoriesResponseMap);
        try {
            metadataCollection = this.groupMerger.fetchAndMergeMetadata(path, repodataFiles, context);
            YumMetadataFile repomdFile = this.groupRepomdCreator.create(metadataCollection);
            if (repomdFile != null) {
                metadataCollection.add(repomdFile);
            }
            Content content = this.saveAllAndDiscardUnused(metadataCollection, YumPathUtils.appendPath(path, REPODATA), etag);
            return content;
        }
        finally {
            this.cleanupFiles(metadataCollection);
        }
    }

    @Override
    @Nullable
    public Content get(String requestPath) {
        String path = requestPath.substring(1);
        try {
            return this.yumFacet.getAssetAsContent(path);
        }
        catch (IOException e) {
            this.log.warn("Unable to fetch {}", (Object)path, (Object)e);
            return null;
        }
    }

    public List<Repository> leafMembers() {
        List repositories = super.leafMembers();
        repositories.add(0, this.getRepository());
        return repositories;
    }

    @Nullable
    private Content saveAllAndDiscardUnused(List<YumMetadataFile> metadataCollection, String path, Optional<String> etag) {
        Iterable<Asset> currentMetadata = this.retrieveCurrentMetadata(path);
        List<Asset> savedAssets = this.saveMetadata(metadataCollection, path, etag);
        this.discardUnusedMetadata(Lists.newArrayList(currentMetadata), savedAssets);
        try {
            return this.yumFacet.getAssetAsContent(YumPathUtils.appendPath(path, REPOMD_FILE));
        }
        catch (IOException e) {
            this.log.error("Unable to find asset {}", (Object)path, (Object)e);
            return null;
        }
    }

    @TransactionalTouchMetadata
    protected Iterable<Asset> retrieveCurrentMetadata(String path) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return tx.findAssets(this.orientYumQueryComponent.repoDataQuery(path), Collections.singletonList(this.getRepository()));
    }

    @TransactionalDeleteBlob
    protected void deleteMetadata(Asset asset) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        tx.deleteAsset(asset);
    }

    private void discardUnusedMetadata(List<Asset> currentMetadata, List<Asset> newMetadata) {
        currentMetadata.stream().filter(metadata -> this.doesntExistIn((Asset)metadata, newMetadata)).collect(Collectors.toList()).forEach(this::deleteMetadata);
    }

    private boolean doesntExistIn(Asset currentMeta, List<Asset> newMetadata) {
        return newMetadata.stream().noneMatch(newMeta -> newMeta.name().equals(currentMeta.name()));
    }

    private List<Asset> saveMetadata(List<YumMetadataFile> metadataCollection, String path, Optional<String> etag) {
        try {
            ArrayList<Asset> savedAssets = new ArrayList<Asset>();
            for (YumMetadataFile yumMetadataFile : metadataCollection) {
                Asset asset = this.save(path, yumMetadataFile, etag);
                if (asset == null) continue;
                savedAssets.add(asset);
            }
            return savedAssets;
        }
        catch (IOException e) {
            this.log.error("Unable to save metadata to {}", (Object)path, (Object)e);
            return Collections.emptyList();
        }
    }

    @Nullable
    @TransactionalTouchMetadata
    protected Asset getAssetFromContent(Content content) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return Content.findAsset((StorageTx)tx, (Bucket)tx.findBucket(this.getRepository()), (Content)content);
    }

    private void cleanupFiles(List<YumMetadataFile> metadataCollection) {
        metadataCollection.forEach(file -> {
            try {
                String filePath;
                Path path;
                if (Objects.nonNull(file) && Objects.nonNull(path = file.getPath()) && Objects.nonNull(filePath = path.toString()) && !filePath.isEmpty()) {
                    Files.deleteIfExists(path);
                }
            }
            catch (IOException e) {
                this.log.error("Unable to delete {}", (Object)file.getPath(), (Object)e);
            }
        });
    }

    @Nullable
    private Asset save(String path, YumMetadataFile yumGroupFile, Optional<String> optEtag) throws IOException {
        TempBlob tempBlob;
        block10: {
            Asset asset;
            block11: {
                YumMetadata yumMetadata = this.getYumMetadata(yumGroupFile);
                Throwable throwable = null;
                Object var6_7 = null;
                tempBlob = this.convertFileToTempBlob(this.getRepository(), yumGroupFile);
                try {
                    if (tempBlob == null) break block10;
                    Content content = new Content(this.toPayload(yumGroupFile, yumMetadata));
                    optEtag.ifPresent(etag -> {
                        Object object = content.getAttributes().set("etag", etag);
                    });
                    this.maintainCacheInfo(content.getAttributes());
                    Content metadata = this.yumFacet.storeMetadata(this.buildPath(path, yumMetadata), tempBlob, (Payload)content, yumGroupFile.getType().getKind());
                    asset = this.getAssetFromContent(metadata);
                    if (tempBlob == null) break block11;
                }
                catch (Throwable throwable2) {
                    try {
                        if (tempBlob != null) {
                            tempBlob.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                tempBlob.close();
            }
            return asset;
        }
        if (tempBlob != null) {
            tempBlob.close();
        }
        return null;
    }

    private YumMetadata getYumMetadata(YumMetadataFile yumGroupFile) throws IOException {
        YumMetadata yumMetadata = yumGroupFile.getType().equals((Object)YumMetadataType.REPOMD) ? new YumMetadata(YumMetadataType.REPOMD) : YumMetadataUtils.readCompressedMetadata(yumGroupFile);
        return yumMetadata;
    }

    private Payload toPayload(YumMetadataFile yumGroupFile, YumMetadata yumMetadata) throws IOException {
        try {
            return new PathPayload(yumGroupFile.getPath(), this.getContentType(yumMetadata));
        }
        catch (Exception e) {
            this.log.debug("Failed to detect content type for file {} metadata {}", new Object[]{yumGroupFile, yumMetadata, e});
            return new PathPayload(yumGroupFile.getPath(), null);
        }
    }

    private String getContentType(YumMetadata yumMetadata) {
        return yumMetadata.getType().getFileType().equals("xml") ? "application/xml" : "application/gzip";
    }

    @Nullable
    private TempBlob convertFileToTempBlob(Repository repository, YumMetadataFile yumGroupFile) throws IOException {
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedInputStream tempFileInputStream = new BufferedInputStream(Files.newInputStream(yumGroupFile.getPath(), new OpenOption[0]));){
                return storageFacet.createTempBlob((InputStream)tempFileInputStream, YumMetadataUtils.HASH_ALGORITHMS);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException e) {
            this.log.warn("Unable to open file of type {} for reading", (Object)yumGroupFile.getType().getType(), (Object)e);
            return null;
        }
    }

    private String buildPath(String basePath, YumMetadata yumMetadata) {
        String filename = this.getFilename(yumMetadata) + this.getExtension(yumMetadata);
        if (basePath.endsWith("/")) {
            return String.valueOf(basePath) + filename;
        }
        return String.valueOf(basePath) + "/" + filename;
    }

    private String getFilename(YumMetadata yumMetadata) {
        String type = yumMetadata.getType().getType();
        if (type.equals(YumMetadataType.COMPS.getType()) || type.equals(YumMetadataType.COMPS_GZ.getType())) {
            return "comps";
        }
        if (type.equals(YumMetadataType.REPOMD.getType())) {
            return type;
        }
        return String.valueOf(yumMetadata.getChecksum()) + "-" + type;
    }

    private String getExtension(YumMetadata yumMetadata) {
        return "." + yumMetadata.getType().getFileType();
    }
}

