/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.orient.internal.createrepo;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.hash.HashCode;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.AbstractMetadataNode;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.yum.internal.createrepo.CreateRepoService;
import org.sonatype.nexus.repository.yum.internal.createrepo.MetadataBlob;
import org.sonatype.nexus.repository.yum.internal.createrepo.MetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.RepomdMetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumDirectory;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataFile;
import org.sonatype.nexus.repository.yum.internal.metadata.MetadataWriterFactory;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadataType;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpm;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmParser;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;
import org.sonatype.nexus.repository.yum.internal.xmltools.AttributeXmlValueExtractor;
import org.sonatype.nexus.repository.yum.internal.xmltools.ElementXmlValueExtractor;
import org.sonatype.nexus.repository.yum.orient.internal.createrepo.OrientCreateRepoState;
import org.sonatype.nexus.repository.yum.orient.internal.database.OrientYumQueryComponent;
import org.sonatype.nexus.repository.yum.orient.internal.hosted.OrientYumHostedFacet;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class OrientCreateRepoServiceImpl
extends ComponentSupport
implements CreateRepoService {
    private static final String PACKAGE = "package";
    private static final String LOCATION = "location";
    private static final String LOCATION_ATTRIBUTE = "href";
    private static final String CHECKSUM = "checksum";
    private final YumRpmParser rpmParser;
    private final OrientYumQueryComponent orientYumQueryComponent;
    private final Clock clock;

    @Inject
    public OrientCreateRepoServiceImpl(YumRpmParser rpmParser, Clock clock, OrientYumQueryComponent orientYumQueryComponent) {
        this.rpmParser = (YumRpmParser)((Object)Preconditions.checkNotNull((Object)((Object)rpmParser)));
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.orientYumQueryComponent = (OrientYumQueryComponent)((Object)Preconditions.checkNotNull((Object)((Object)orientYumQueryComponent)));
    }

    @Override
    public void buildMetadataUsingCaching(Repository repository, Consumer<List<MetadataBlob>> updateListener) {
        this.buildMetadata(repository, true, updateListener, Collections.emptyList());
    }

    @Override
    public void buildMetadataUsingCaching(Repository repository, Consumer<List<MetadataBlob>> updateListener, List<String> movedComponentIds) {
        this.buildMetadata(repository, true, updateListener, movedComponentIds);
    }

    @Override
    public void buildMetadataWithoutCaching(Repository repository, Consumer<List<MetadataBlob>> updateListener) {
        this.buildMetadata(repository, false, updateListener, Collections.emptyList());
    }

    private void buildMetadata(Repository repository, boolean useCache, Consumer<List<MetadataBlob>> updateListener, List<String> movedComponentIds) {
        try {
            Integer repodataDepth = ((OrientYumHostedFacet)repository.facet(OrientYumHostedFacet.class)).getRepodataDepth();
            this.buildMetadata(new OrientCreateRepoState.CreateRepoStateBuilder().withTx(UnitOfWork::currentTx).withRepository(repository).withRepodataDepth(repodataDepth).withUseCache(useCache).build(), updateListener, movedComponentIds);
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private void buildMetadata(OrientCreateRepoState state, Consumer<List<MetadataBlob>> updateListener, List<String> movedComponentIds) throws IOException, XMLStreamException {
        this.calculateDirectories(state, updateListener, movedComponentIds);
        if (state.getDirectories().size() == 0) {
            this.log.debug("Found no directories for metadata in {}", (Object)state.getRepository().getName());
            return;
        }
        try {
            this.convertDirectoriesToMetadata(state, updateListener, movedComponentIds);
        }
        finally {
            this.deleteTempFiles(state);
        }
    }

    private void deleteTempFiles(OrientCreateRepoState state) {
        this.log.debug("Removing temp files used in Yum metadata generation");
        for (YumDirectory directory : state.getDirectories()) {
            for (YumMetadataFile file : directory.getFiles()) {
                try {
                    this.log.debug("Removing temporary Yum metadata file {}", (Object)file.getPath());
                    Files.delete(file.getPath());
                }
                catch (IOException e) {
                    this.log.error("Failed to delete temporary file {} during yum metadata creation", (Object)file.getPath(), (Object)e);
                }
            }
        }
    }

    private void convertDirectoriesToMetadata(OrientCreateRepoState state, Consumer<List<MetadataBlob>> updateListener, List<String> movedComponentIds) throws IOException, XMLStreamException {
        for (YumDirectory directory : state.getDirectories()) {
            this.log.debug("Converting directory {} to metadata", (Object)directory.getPath());
            this.createWriters(state, directory);
            this.writeMetadata(state, directory, movedComponentIds);
            HashMap<YumMetadataType, YumMetadata> metadataDetails = new HashMap<YumMetadataType, YumMetadata>();
            this.writeRepomd(directory, state, metadataDetails);
            ArrayList<MetadataBlob> blobs = new ArrayList<MetadataBlob>(this.convertToMetadataBlobs(directory, metadataDetails));
            TransactionalStoreBlob.operation.withDb(((StorageFacet)state.getRepository().facet(StorageFacet.class)).txSupplier()).run(() -> updateListener.accept(blobs));
        }
    }

    private void createWriters(OrientCreateRepoState state, YumDirectory directory) throws IOException, XMLStreamException {
        for (YumMetadataFile file : directory.getFiles()) {
            MetadataWriter<YumRpm> writer;
            if (file.getType() == YumMetadataType.REPOMD || (writer = MetadataWriterFactory.getWriter(file)) == null) continue;
            state.putWriter(file.getType(), writer);
        }
    }

    private void calculateDirectories(OrientCreateRepoState state, Consumer<List<MetadataBlob>> updateListener, List<String> movedComponentIds) throws IOException {
        this.log.debug("Calculating directories for generating Yum metadata for repository {}", (Object)state.getRepository().getName());
        Integer repodataDepth = ((OrientYumHostedFacet)state.getRepository().facet(OrientYumHostedFacet.class)).getRepodataDepth();
        long rpmCount = this.orientYumQueryComponent.countRpms(state.getTx(), state.getRepository());
        long compsCount = this.orientYumQueryComponent.countComps(state.getTx(), state.getRepository());
        if (rpmCount == 0L && compsCount == 0L && movedComponentIds.isEmpty()) {
            this.log.debug("Found no RPMs and Comps in repository: {}", (Object)state.getRepository().getName());
            updateListener.accept(Collections.emptyList());
            this.removeRpmsRemovedFlagsIfPresent(state);
            return;
        }
        if (repodataDepth == 0) {
            YumDirectory directory = new YumDirectory("");
            directory.setRpmCount(rpmCount);
            directory.setUseCache(this.useCachedMetadata(state));
            directory.setRpmsRemoved(this.haveRpmsBeenRemovedFromRoot(state));
            this.addFilesToDirectory(directory);
            state.addDirectory(directory);
            this.log.debug("Repo depth 0, using {}", (Object)directory);
        } else {
            this.deriveDirectoriesFromRpms(state, movedComponentIds);
        }
    }

    private void removeRpmsRemovedFlagsIfPresent(OrientCreateRepoState state) {
        OrientYumHostedFacet yumHostedFacet = (OrientYumHostedFacet)state.getRepository().facet(OrientYumHostedFacet.class);
        for (String removedRpmPath : this.fetchRepomdPathsOfDeletedRpms(state)) {
            yumHostedFacet.markMetadataAsRpmsRemovedInNewTx(removedRpmPath, state.getTx(), false);
            this.log.debug("Removed '{}' attribute from {}", (Object)"rpms_removed", (Object)removedRpmPath);
        }
    }

    private boolean haveRpmsBeenRemovedFromRoot(OrientCreateRepoState state) {
        Iterable<Asset> repomd = this.orientYumQueryComponent.findRepomd(state.getTx(), state.getRepository());
        Iterator<Asset> iterator = repomd.iterator();
        if (iterator.hasNext()) {
            Asset repomdAsset = iterator.next();
            Boolean rpmsRemoved = (Boolean)repomdAsset.formatAttributes().get("rpms_removed", Boolean.class);
            return BooleanUtils.isTrue((Boolean)rpmsRemoved);
        }
        return false;
    }

    private void deriveDirectoriesFromRpms(OrientCreateRepoState state, List<String> componentIds) throws IOException {
        HashMap<String, YumDirectory> directories = new HashMap<String, YumDirectory>();
        this.calculateDirectoriesWithModifiedRpms(state, directories, componentIds);
        this.calculateDirectoriesWithRemovedRpms(state, directories);
        for (YumDirectory directory : directories.values()) {
            this.addFilesToDirectory(directory);
            state.addDirectory(directory);
        }
    }

    private void calculateDirectoriesWithRemovedRpms(OrientCreateRepoState state, Map<String, YumDirectory> directories) {
        for (String removedRpmPath : this.fetchRepomdPathsOfDeletedRpms(state)) {
            YumDirectory directory = this.deriveDirectoryForPath(state, directories, removedRpmPath);
            if (directory == null) continue;
            this.log.debug("Removed RPMs in {}", (Object)directory);
            directory.setRpmsRemoved(true);
        }
    }

    private List<String> fetchRepomdPathsOfDeletedRpms(OrientCreateRepoState state) {
        Repository repository = state.getRepository();
        List<String> paths = this.orientYumQueryComponent.getMetadataPathsThatHaveHadRpmsRemoved(state.getTx(), repository);
        this.log.debug("Repomd paths of deleted RPMs in '{}' repository: {}", (Object)repository.getName(), paths);
        return paths;
    }

    private void calculateDirectoriesWithModifiedRpms(OrientCreateRepoState state, Map<String, YumDirectory> directories, List<String> componentIds) {
        StreamSupport.stream(Iterables.transform(this.browseRpmsForDirectoryCalculation(state, componentIds), AbstractMetadataNode::name).spliterator(), false).forEach(rpm -> {
            YumDirectory yumDirectory = this.deriveDirectoryForPath(state, directories, (String)rpm);
        });
        this.log.debug("Calculated directories with modified RPMs: {}", directories);
    }

    @Nullable
    private YumDirectory deriveDirectoryForPath(OrientCreateRepoState state, Map<String, YumDirectory> directories, String rpm) {
        this.log.debug("Deriving directory for {}", (Object)rpm);
        Optional<String> directoryName = YumPathUtils.extractDirectoryAtDepth(rpm, state.getRepodataDepth());
        if (directoryName.isPresent()) {
            YumDirectory directory = directories.computeIfAbsent(directoryName.get(), path -> {
                YumDirectory computed = new YumDirectory((String)path);
                computed.setRpmCount(this.orientYumQueryComponent.countRpmsInDirectoryInNewTx((String)path, state.getTx(), state.getRepository()));
                this.log.debug("Adding new directory {}", (Object)computed);
                return computed;
            });
            if (!directory.isUseCache() && this.useCachedMetadata(state, directory)) {
                this.log.debug("Setting use cached metadata for {}", (Object)directory);
                directory.setUseCache(true);
            }
            return directory;
        }
        this.log.warn("RPM ({}) found above the repodata depth {} while creating the Yum Metadata for {}. This is likely a result of the repodata depth being changed and this RPM will not be included in the metadata and should be removed from the repository.", new Object[]{rpm, state.getRepodataDepth(), state.getRepository().getName()});
        return null;
    }

    private void addFilesToDirectory(YumDirectory directory) throws IOException {
        directory.getFiles().add(new YumMetadataFile(YumMetadataType.FILELISTS, Files.createTempFile(YumMetadataType.FILELISTS.lowerName(), "xml.gz", new FileAttribute[0])));
        directory.getFiles().add(new YumMetadataFile(YumMetadataType.PRIMARY, Files.createTempFile(YumMetadataType.PRIMARY.lowerName(), "xml.gz", new FileAttribute[0])));
        directory.getFiles().add(new YumMetadataFile(YumMetadataType.OTHER, Files.createTempFile(YumMetadataType.OTHER.lowerName(), "xml.gz", new FileAttribute[0])));
        directory.getFiles().add(new YumMetadataFile(YumMetadataType.REPOMD, Files.createTempFile(YumMetadataType.REPOMD.lowerName(), "xml", new FileAttribute[0])));
    }

    private void writeRepomd(YumDirectory directory, OrientCreateRepoState state, Map<YumMetadataType, YumMetadata> metadataDetails) throws XMLStreamException, IOException {
        int startTimeInSeconds = (int)(this.clock.millis() / 1000L);
        this.log.debug("Building repomd.xml for repository {} and directory {}", (Object)state.getRepository().getName(), (Object)directory.getName());
        Path repomdXml = directory.getFiles().stream().filter(f -> f.getType() == YumMetadataType.REPOMD).findFirst().get().getPath();
        Throwable throwable = null;
        Object var7_8 = null;
        try (RepomdMetadataWriter repomdMetadataWriter = new RepomdMetadataWriter(Files.newOutputStream(repomdXml, new OpenOption[0]), startTimeInSeconds);){
            repomdMetadataWriter.startMetadata(directory.getFiles().size() - 1);
            this.readMetadataAndAppendToRepomd(directory, metadataDetails, repomdMetadataWriter);
            this.appendComps(state, repomdMetadataWriter, directory);
            repomdMetadataWriter.end();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void readMetadataAndAppendToRepomd(YumDirectory directory, Map<YumMetadataType, YumMetadata> metadataDetails, RepomdMetadataWriter repomdMetadataWriter) throws IOException, XMLStreamException {
        for (YumMetadataFile file : directory.getFiles()) {
            if (file.getType() == YumMetadataType.REPOMD) continue;
            this.log.debug("Reading metadata file {} from directory {} to get checksums ", (Object)file.getPath(), (Object)directory.getName());
            YumMetadata metadata = YumMetadataUtils.readCompressedMetadata(file);
            metadataDetails.put(file.getType(), metadata);
            repomdMetadataWriter.append(metadata);
        }
    }

    private void appendComps(OrientCreateRepoState state, RepomdMetadataWriter repomdMetadataWriter, YumDirectory directory) throws IOException, XMLStreamException {
        this.log.debug("Searching for comps.xml to add to metadata for directory {}", (Object)directory.getName());
        String path = Optional.ofNullable(directory.getName()).orElse("");
        OrientYumHostedFacet yumHostedFacet = (OrientYumHostedFacet)state.getRepository().facet(OrientYumHostedFacet.class);
        for (Asset comp : this.orientYumQueryComponent.findCompsByPath(path, state.getTx(), state.getRepository())) {
            YumMetadata compsMetadata;
            if (comp.name().contains("xml.gz")) {
                this.log.debug("Found compressed comps.xml: {}", (Object)comp.name());
                compsMetadata = YumMetadataUtils.readCompressedMetadata(new YumMetadataFile(YumMetadataType.COMPS_GZ, Paths.get(comp.name(), new String[0])), yumHostedFacet.requireBlob(state.getTx(), comp.requireBlobRef()).getInputStream());
            } else {
                this.log.debug("Found uncompressed comps.xml: {}", (Object)comp.name());
                HashCode checksum = comp.getChecksum(HashAlgorithm.SHA256);
                Long size = comp.size();
                compsMetadata = new YumMetadata(YumMetadataType.COMPS).setChecksum(checksum != null ? checksum.toString() : null).setSize(size != null ? size : 0L);
            }
            this.log.debug("Appending {} to repomd.xml for directory {}", (Object)comp.name(), (Object)directory.getName());
            repomdMetadataWriter.append(compsMetadata);
        }
    }

    private List<MetadataBlob> convertToMetadataBlobs(YumDirectory directory, Map<YumMetadataType, YumMetadata> metadataDetails) {
        ArrayList<MetadataBlob> metadata = new ArrayList<MetadataBlob>();
        for (YumMetadataFile file : directory.getFiles()) {
            YumMetadataType type = file.getType();
            String path = this.buildPath(directory.getName(), type, metadataDetails.get((Object)type));
            String contentType = path.contains(".gz") ? "application/x-gzip" : "application/xml";
            metadata.add(new MetadataBlob(file.getPath(), path, contentType, type.getKind(), directory.getRpmCount()));
        }
        return metadata;
    }

    private String buildPath(String directoryName, YumMetadataType type, @Nullable YumMetadata yumMetadata) {
        String metadataName;
        if (type == YumMetadataType.REPOMD) {
            metadataName = "repodata/repomd.xml";
        } else {
            String checksum = yumMetadata != null ? yumMetadata.getChecksum() : "";
            metadataName = YumPathUtils.buildMetadataFilePath(checksum, type.lowerName());
        }
        return !directoryName.isEmpty() ? String.valueOf(directoryName) + "/" + metadataName : metadataName;
    }

    /*
     * Unable to fully structure code
     */
    private void writeMetadata(OrientCreateRepoState state, YumDirectory directory, List<String> movedComponentIds) {
        this.log.debug("Writing non-repomd metadata for repository {} and directory {}", (Object)state.getRepository().getName(), (Object)directory.getName());
        try {
            try {
                for (MetadataWriter<YumRpm> writer : state.getWriters().values()) {
                    writer.start((int)directory.getRpmCount());
                }
                if (directory.isUseCache()) {
                    this.log.debug("Directory {} is marked as use cache, appending metadata from existing cached files", (Object)directory.getName());
                    newRpms = new HashSet<String>();
                    for (Asset rpm : this.browseNewRpms(state, directory)) {
                        newRpms.add(rpm.name());
                        this.appendRpm(state, directory, rpm);
                    }
                    for (Asset rpm : this.findMovedRpms(state, directory, movedComponentIds)) {
                        if (newRpms.contains(rpm.name())) continue;
                        newRpms.add(rpm.name());
                        this.appendRpm(state, directory, rpm);
                    }
                    this.log.debug("Found {} new RPMs to be added", (Object)newRpms.size());
                    this.appendCachedEntries(state, directory, newRpms);
                } else {
                    this.loopAllRpmsAndAppend(state, directory);
                }
                for (MetadataWriter<YumRpm> writer : state.getWriters().values()) {
                    writer.end();
                }
            }
            catch (IOException | XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            ** for (writer : state.getWriters().values())
        }
lbl-1000:
        // 1 sources

        {
            writer.close();
            continue;
        }
lbl35:
        // 1 sources

    }

    private void loopAllRpmsAndAppend(OrientCreateRepoState state, YumDirectory directory) throws IOException, XMLStreamException {
        for (Asset rpmAsset : this.browseAllRpms(state, directory)) {
            this.appendRpm(state, directory, rpmAsset);
        }
    }

    private void appendRpm(OrientCreateRepoState state, YumDirectory directory, Asset rpmAsset) throws IOException, XMLStreamException {
        this.log.debug("Adding RPM {} to metadata for repository {} and directory {}", new Object[]{rpmAsset.name(), state.getRepository().getName(), directory.getName()});
        OrientYumHostedFacet yumHostedFacet = (OrientYumHostedFacet)state.getRepository().facet(OrientYumHostedFacet.class);
        Blob blob = yumHostedFacet.getBlob(state.getTx(), rpmAsset.requireBlobRef());
        this.writeAssetToMetadata(state, rpmAsset, blob);
    }

    private void appendCachedEntries(OrientCreateRepoState state, YumDirectory directory, Set<String> newRpms) throws XMLStreamException, IOException {
        Map<YumMetadataType, Asset> repodata = ((OrientYumHostedFacet)state.getRepository().facet(OrientYumHostedFacet.class)).findRepodataBasedOnRepomd(directory);
        if (!this.allMetadataExists(repodata)) {
            this.log.warn("A metadata file was deleted during metadata generation, falling back to non-cached method");
            this.loopAllRpmsAndAppend(state, directory);
            return;
        }
        MetadataWriter<YumRpm> primaryWriter = state.getWriters().get((Object)YumMetadataType.PRIMARY);
        Asset primaryXml = repodata.get((Object)YumMetadataType.PRIMARY);
        OrientYumHostedFacet yumHostedFacet = (OrientYumHostedFacet)state.getRepository().facet(OrientYumHostedFacet.class);
        Blob primaryXmlBlob = yumHostedFacet.getBlob(state.getTx(), primaryXml.requireBlobRef());
        if (primaryXmlBlob != null) {
            Throwable throwable = null;
            Object var10_11 = null;
            try (InputStream xml = this.gzipIn(primaryXmlBlob.getInputStream());){
                Set<String> excludedChecksums = this.writeToPrimaryUsingCache(state, newRpms, primaryWriter, xml, directory);
                this.writeNonPrimaryFilesUsingCache(state, repodata, excludedChecksums);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void writeNonPrimaryFilesUsingCache(OrientCreateRepoState state, Map<YumMetadataType, Asset> repodata, Set<String> excludedChecksums) throws XMLStreamException, IOException {
        OrientYumHostedFacet yumHostedFacet = (OrientYumHostedFacet)state.getRepository().facet(OrientYumHostedFacet.class);
        for (Map.Entry<YumMetadataType, MetadataWriter<YumRpm>> entry : state.getWriters().entrySet()) {
            YumMetadataType type = entry.getKey();
            if (type == YumMetadataType.PRIMARY) continue;
            MetadataWriter<YumRpm> writer = entry.getValue();
            Asset asset = repodata.get((Object)type);
            if (asset == null) continue;
            Blob metadataXml = yumHostedFacet.getBlob(state.getTx(), asset.requireBlobRef());
            Throwable throwable = null;
            Object var12_13 = null;
            try (InputStream in = this.gzipIn(metadataXml.getInputStream());){
                writer.copyFromXml(in, PACKAGE, block -> {
                    String checksum = new AttributeXmlValueExtractor(PACKAGE, "pkgid").extract((Collection<XMLEvent>)block);
                    return !excludedChecksums.contains(checksum);
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private Set<String> writeToPrimaryUsingCache(OrientCreateRepoState state, Set<String> addedRpms, MetadataWriter<YumRpm> primaryWriter, InputStream xml, YumDirectory directory) throws XMLStreamException {
        HashSet<String> excludedChecksums = new HashSet<String>();
        primaryWriter.copyFromXml(xml, PACKAGE, block -> {
            String location = new AttributeXmlValueExtractor(LOCATION, LOCATION_ATTRIBUTE).extract((Collection<XMLEvent>)block);
            if (location != null && !addedRpms.contains(location) && this.rpmExists(state, location, directory)) {
                return true;
            }
            String checksum = new ElementXmlValueExtractor(CHECKSUM).extract((Collection<XMLEvent>)block);
            if (checksum != null) {
                excludedChecksums.add(checksum);
            }
            return false;
        });
        return excludedChecksums;
    }

    private boolean rpmExists(OrientCreateRepoState state, String location, YumDirectory directory) {
        String path = location;
        if (StringUtils.isNotBlank((CharSequence)directory.getName())) {
            path = String.valueOf(directory.getName()) + "/" + location;
        }
        Repository repository = state.getRepository();
        OrientYumHostedFacet yumHostedFacet = (OrientYumHostedFacet)repository.facet(OrientYumHostedFacet.class);
        return !directory.isRpmsRemoved() || yumHostedFacet.assetExists(state.getTx(), path, repository);
    }

    private InputStream gzipIn(InputStream inputStream) throws IOException {
        return new GzipCompressorInputStream((InputStream)new BufferedInputStream(inputStream));
    }

    private void writeAssetToMetadata(OrientCreateRepoState state, Asset rpmAsset, @Nullable Blob blob) throws IOException, XMLStreamException {
        block11: {
            if (blob != null) {
                Throwable throwable = null;
                Object var5_6 = null;
                try (InputStream in = blob.getInputStream();){
                    YumRpm rpm = this.rpmParser.parse(in, this.rpmLocationRelativeToDepth(rpmAsset, state.getRepodataDepth()));
                    for (MetadataWriter<YumRpm> writer : state.getWriters().values()) {
                        writer.append(rpm);
                    }
                    break block11;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.log.warn("Excluding {} from the generated metadata because the blob could not be found", (Object)rpmAsset.name());
        }
    }

    private String rpmLocationRelativeToDepth(Asset rpmAsset, int depth) {
        if (depth == 0) {
            return rpmAsset.name();
        }
        String rootDirectory = YumPathUtils.extractDirectoryAtDepth(rpmAsset.name(), depth).orElse(rpmAsset.name());
        return rpmAsset.name().substring(rootDirectory.length() + 1);
    }

    private boolean useCachedMetadata(OrientCreateRepoState state) {
        return this.useCachedMetadata(state, null);
    }

    private boolean useCachedMetadata(OrientCreateRepoState state, YumDirectory directory) {
        OrientYumHostedFacet hosted = (OrientYumHostedFacet)state.getRepository().facet(OrientYumHostedFacet.class);
        if (state.isUseCache() && hosted.getMetadataGenerationStartedTime() > 0L) {
            if (directory == null && state.getRepodataDepth() > 0) {
                return true;
            }
            Map<YumMetadataType, Asset> repodata = ((OrientYumHostedFacet)state.getRepository().facet(OrientYumHostedFacet.class)).findRepodataBasedOnRepomd(directory);
            return this.allMetadataExists(repodata);
        }
        return false;
    }

    private boolean allMetadataExists(Map<YumMetadataType, Asset> repodata) {
        return repodata.containsKey((Object)YumMetadataType.PRIMARY) && repodata.containsKey((Object)YumMetadataType.FILELISTS) && repodata.containsKey((Object)YumMetadataType.OTHER);
    }

    private Iterable<Asset> browseRpmsForDirectoryCalculation(OrientCreateRepoState state, List<String> componentIds) {
        if (this.useCachedMetadata(state)) {
            return Iterables.concat(this.browseNewRpms(state, null), this.browseNewComps(state), this.findMovedRpms(state, null, componentIds));
        }
        return Iterables.concat(this.browseAllRpms(state, null), this.browseAllComps(state));
    }

    private Iterable<Asset> browseNewRpms(OrientCreateRepoState state, YumDirectory directory) {
        String path = directory == null ? "" : directory.getPath();
        OrientYumHostedFacet hosted = (OrientYumHostedFacet)state.getRepository().facet(OrientYumHostedFacet.class);
        return this.orientYumQueryComponent.browseRpmBlobsUpdatedSince(path, state.getTx(), state.getRepository(), hosted.getMetadataGenerationStartedTime());
    }

    private Iterable<Asset> findMovedRpms(OrientCreateRepoState state, YumDirectory directory, List<String> componentIds) {
        String path = directory == null ? "" : directory.getPath();
        return this.orientYumQueryComponent.findAssetsByComponentIds(path, state.getTx(), componentIds, state.getRepository());
    }

    private Iterable<Asset> browseAllRpms(OrientCreateRepoState state, YumDirectory directory) {
        String path = directory == null ? "" : directory.getPath();
        return this.orientYumQueryComponent.browseRpmsForPath(path, state.getTx(), state.getRepository());
    }

    private Iterable<Asset> browseNewComps(OrientCreateRepoState state) {
        OrientYumHostedFacet hosted = (OrientYumHostedFacet)state.getRepository().facet(OrientYumHostedFacet.class);
        return this.orientYumQueryComponent.browseCompsUpdatedSince(state.getTx(), state.getRepository(), hosted.getMetadataGenerationStartedTime());
    }

    private Iterable<Asset> browseAllComps(OrientCreateRepoState state) {
        return this.orientYumQueryComponent.browseAllComps(state.getTx(), state.getRepository());
    }
}

