/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.hash.MultiHashingInputStream;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.common.io.SafeXml;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataFile;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class YumMetadataUtils {
    private static final Logger log = LoggerFactory.getLogger(YumMetadataUtils.class);
    private static final XPath X_PATH = XPathFactory.newInstance().newXPath();
    public static final List<HashAlgorithm> HASH_ALGORITHMS = ImmutableList.of((Object)HashAlgorithm.SHA256, (Object)HashAlgorithm.SHA1, (Object)HashAlgorithm.SHA512, (Object)HashAlgorithm.MD5);
    private static final String GZ = ".gz";
    private static final String XZ = ".xz";
    private static final String BZIP = ".bz2";

    private YumMetadataUtils() {
    }

    public static YumMetadata readCompressedMetadata(YumMetadataFile metadataFile) throws IOException {
        return YumMetadataUtils.readCompressedMetadata(metadataFile, Files.newInputStream(metadataFile.getPath(), new OpenOption[0]));
    }

    /*
     * Loose catch block
     */
    public static YumMetadata readCompressedMetadata(YumMetadataFile metadataFile, InputStream metadata) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream in = new BufferedInputStream(metadata);){
            YumMetadata yumMetadata;
            InputStream inputStream;
            Throwable throwable2;
            block19: {
                CountingInputStream countStream = new CountingInputStream((InputStream)in);
                MultiHashingInputStream hash = new MultiHashingInputStream(HASH_ALGORITHMS, (InputStream)countStream);
                throwable2 = null;
                Object var8_11 = null;
                inputStream = YumMetadataUtils.xmlInputStream(YumMetadataUtils.getFileName(metadataFile), (InputStream)hash);
                CountingInputStream openCountStream = new CountingInputStream(inputStream);
                MultiHashingInputStream openHash = new MultiHashingInputStream(HASH_ALGORITHMS, (InputStream)openCountStream);
                ByteStreams.copy((InputStream)openHash, (OutputStream)ByteStreams.nullOutputStream());
                yumMetadata = new YumMetadata(metadataFile.getType()).setChecksum(((HashCode)hash.hashes().get(HashAlgorithm.SHA256)).toString()).setOpenChecksum(((HashCode)openHash.hashes().get(HashAlgorithm.SHA256)).toString()).setSize(countStream.getCount()).setOpenSize(openCountStream.getCount());
                if (inputStream == null) break block19;
                inputStream.close();
            }
            return yumMetadata;
            {
                catch (Throwable throwable3) {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    private static String getFileName(YumMetadataFile metadataFile) {
        if (metadataFile != null && metadataFile.getPath() != null && metadataFile.getPath().getFileName() != null) {
            return metadataFile.getPath().getFileName().toString();
        }
        throw new RuntimeException("Unable to retrieve filename");
    }

    public static OutputStream xmlOutputStream(String fileName, Path tempFile) throws IOException {
        BufferedOutputStream result = new BufferedOutputStream(Files.newOutputStream(tempFile, new OpenOption[0]));
        try {
            if (YumMetadataUtils.isCompressedWithFormat(fileName, GZ)) {
                return new GzipCompressorOutputStream((OutputStream)result);
            }
            if (YumMetadataUtils.isCompressedWithFormat(fileName, XZ)) {
                return new XZCompressorOutputStream((OutputStream)result);
            }
            if (YumMetadataUtils.isCompressedWithFormat(fileName, BZIP)) {
                return new BZip2CompressorOutputStream((OutputStream)result);
            }
            return result;
        }
        catch (IOException ex) {
            ((OutputStream)result).close();
            throw ex;
        }
    }

    public static InputStream xmlInputStream(String fileName, InputStream primaryInputStream) throws IOException {
        InputStream result = primaryInputStream;
        if (!(primaryInputStream instanceof BufferedInputStream)) {
            result = new BufferedInputStream(primaryInputStream);
        }
        if (YumMetadataUtils.isCompressedWithFormat(fileName, GZ)) {
            return new GzipCompressorInputStream(primaryInputStream);
        }
        if (YumMetadataUtils.isCompressedWithFormat(fileName, XZ)) {
            return new XZCompressorInputStream(primaryInputStream);
        }
        if (YumMetadataUtils.isCompressedWithFormat(fileName, BZIP)) {
            return new BZip2CompressorInputStream(primaryInputStream);
        }
        return result;
    }

    private static boolean isCompressedWithFormat(String fileName, String format) {
        return fileName.endsWith(format);
    }

    public static Document parseRepomdXml(InputStreamSupplier repomdXmlInputStreamSupplier) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream inputStream = repomdXmlInputStreamSupplier.get();){
                DocumentBuilder builder = SafeXml.newdocumentBuilderFactory().newDocumentBuilder();
                return builder.parse(inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public static Optional<String> extractPrimaryLocation(Document repomdXmlDocument) {
        return YumMetadataUtils.getXPathStringByExpression("repomd/data[@type='primary']/location/@href", repomdXmlDocument);
    }

    public static Optional<String> extractFilelistsLocation(Document repomdXmlDocument) {
        return YumMetadataUtils.getXPathStringByExpression("repomd/data[@type='filelists']/location/@href", repomdXmlDocument);
    }

    public static Optional<String> extractOtherLocation(Document repomdXmlDocument) {
        return YumMetadataUtils.getXPathStringByExpression("repomd/data[@type='other']/location/@href", repomdXmlDocument);
    }

    private static Optional<String> getXPathStringByExpression(String xpathExpression, Document repomdXml) {
        try {
            return Optional.ofNullable(((Node)X_PATH.evaluate(xpathExpression, repomdXml, XPathConstants.NODE)).getNodeValue());
        }
        catch (Exception e) {
            log.debug("Unable to process XPath expression {}", (Object)e.getMessage(), (Object)(log.isDebugEnabled() ? e : null));
            return Optional.empty();
        }
    }
}

