/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.metadata;

import com.google.common.io.CountingOutputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.hash.MultiHashingOutputStream;
import org.sonatype.nexus.common.io.SafeXml;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.yum.internal.metadata.CompressedTempBlob;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;
import org.sonatype.nexus.repository.yum.utils.TempBlobConverter;

@Named
@Singleton
public class YumAbsoluteUrlRemover
extends ComponentSupport {
    private static final String BASE_ATTRIBUTE = "base";
    private static final String LOCATION = "location";
    private final TempBlobConverter yumTempBlobConverter;
    private static final String UTF_8 = "UTF-8";

    @Inject
    public YumAbsoluteUrlRemover(TempBlobConverter yumTempBlobConverter) {
        this.yumTempBlobConverter = yumTempBlobConverter;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public CompressedTempBlob removeAbsoluteUrls(TempBlob primary, String fileName, Repository repository) {
        try {
            Path tempFile = Files.createTempFile("yum-primary-" + UUID.randomUUID().toString(), "xml", new FileAttribute[0]);
            try {
                CompressedTempBlob compressedTempBlob;
                block25: {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    InputStream xmlIn = YumMetadataUtils.xmlInputStream(fileName, primary.get());
                    try {
                        Map hashes;
                        long count;
                        MutableBoolean modified = new MutableBoolean(false);
                        Throwable throwable2 = null;
                        Object var13_14 = null;
                        try (OutputStream xmlOut = YumMetadataUtils.xmlOutputStream(fileName, tempFile);){
                            CountingOutputStream countOut = new CountingOutputStream(xmlOut);
                            MultiHashingOutputStream hashOut = new MultiHashingOutputStream(YumMetadataUtils.HASH_ALGORITHMS, (OutputStream)countOut);
                            XMLInputFactory inputFactory = SafeXml.newXmlInputFactory();
                            inputFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                            inputFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                            XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
                            XMLEventReader reader = inputFactory.createXMLEventReader(xmlIn, UTF_8);
                            XMLEventWriter writer = outputFactory.createXMLEventWriter((OutputStream)hashOut, UTF_8);
                            this.streamXmlToWriterAndRemoveAbsoluteUrls(reader, writer, modified);
                            count = countOut.getCount();
                            hashes = hashOut.hashes();
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                        TempBlob tempBlob = this.convertFileToTempBlob(tempFile, repository);
                        compressedTempBlob = new CompressedTempBlob(tempBlob, count, hashes, modified.booleanValue());
                        if (xmlIn == null) break block25;
                    }
                    catch (Throwable throwable4) {
                        try {
                            if (xmlIn != null) {
                                xmlIn.close();
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (throwable == null) {
                                throwable = throwable5;
                            } else if (throwable != throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            throw throwable;
                        }
                    }
                    xmlIn.close();
                }
                return compressedTempBlob;
            }
            finally {
                Files.delete(tempFile);
            }
        }
        catch (IOException | XMLStreamException ex) {
            this.log.error("Failed to fix absolute urls for file {} and blob {}", new Object[]{fileName, primary.getBlob().getId(), ex});
            return new CompressedTempBlob(primary, 0L, primary.getHashes(), false);
        }
    }

    private void streamXmlToWriterAndRemoveAbsoluteUrls(XMLEventReader reader, XMLEventWriter writer, MutableBoolean modified) throws XMLStreamException {
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        while (reader.hasNext()) {
            StartElement startElement;
            XMLEvent event = reader.nextEvent();
            if (event.getEventType() == 1 && (startElement = event.asStartElement()).getName().getLocalPart().equals(LOCATION)) {
                event = this.removeAttributeAndRebuildEvent(eventFactory, event.asStartElement(), modified);
            }
            writer.add(event);
        }
    }

    private StartElement removeAttributeAndRebuildEvent(XMLEventFactory eventFactory, StartElement startElement, MutableBoolean modified) {
        Iterator<Attribute> fixedAttributes = this.removeAbsoluteUrlFromAttributes(startElement.getAttributes(), modified);
        return eventFactory.createStartElement(startElement.getName().getPrefix(), startElement.getName().getNamespaceURI(), startElement.getName().getLocalPart(), fixedAttributes, null);
    }

    private Iterator<Attribute> removeAbsoluteUrlFromAttributes(Iterator<Attribute> attributes, MutableBoolean modified) {
        ArrayList<Attribute> processedAttributes = new ArrayList<Attribute>();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (attribute.getName().getLocalPart().equals(BASE_ATTRIBUTE)) {
                modified.setTrue();
                continue;
            }
            processedAttributes.add(attribute);
        }
        return processedAttributes.iterator();
    }

    private TempBlob convertFileToTempBlob(Path tempFile, Repository repository) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(tempFile, new OpenOption[0]));){
            return this.yumTempBlobConverter.toTempBlob(is, repository);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsAbsoluteUrl(TempBlob primary, String fileName) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream xmlIn = YumMetadataUtils.xmlInputStream(fileName, primary.get());){
                Iterator<Attribute> attributes;
                XMLEvent event;
                XMLInputFactory inputFactory = SafeXml.newXmlInputFactory();
                XMLEventReader reader = inputFactory.createXMLEventReader(xmlIn, UTF_8);
                do {
                    if (reader.hasNext()) continue;
                    return false;
                } while ((event = reader.nextEvent()).getEventType() != 1 || !event.asStartElement().getName().getLocalPart().equals(LOCATION) || !this.containsBaseAttribute(attributes = event.asStartElement().getAttributes()));
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException | XMLStreamException ex) {
            this.log.error("Failed to find absolute urls for file {} and blob {}", new Object[]{fileName, primary.getBlob().getId(), ex});
            return false;
        }
    }

    private boolean containsBaseAttribute(Iterator<Attribute> attributes) {
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (!attribute.getName().getLocalPart().equals(BASE_ATTRIBUTE)) continue;
            return true;
        }
        return false;
    }
}

