/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.metadata;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.sonatype.nexus.repository.yum.internal.createrepo.FileListMetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.MetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.OtherMetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.PrimaryMetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataFile;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpm;

public class MetadataWriterFactory {
    @Nullable
    public static MetadataWriter<YumRpm> getWriter(YumMetadataFile file) throws IOException, XMLStreamException {
        switch (file.getType()) {
            case FILELISTS: {
                return new FileListMetadataWriter(MetadataWriterFactory.out(file.getPath()));
            }
            case PRIMARY: {
                return new PrimaryMetadataWriter(MetadataWriterFactory.out(file.getPath()));
            }
            case OTHER: {
                return new OtherMetadataWriter(MetadataWriterFactory.out(file.getPath()));
            }
        }
        return null;
    }

    private static OutputStream out(Path path) throws IOException {
        return new BufferedOutputStream((OutputStream)new GzipCompressorOutputStream(Files.newOutputStream(path, new OpenOption[0])));
    }
}

