/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.mergerepo;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.common.io.SafeXml;
import org.sonatype.nexus.repository.yum.internal.mergerepo.XmlBlockDeduper;

public class YumMetadataMerger
extends ComponentSupport {
    protected static final String PACKAGES = "packages";
    protected static final String PACKAGE_COUNT = "#packageCount";
    private static final XMLEventFactory xmlEventFactory = XMLEventFactory.newInstance();
    private static final XMLInputFactory xmlInputFactory = SafeXml.newXmlInputFactory();
    private static final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    private final List<XmlBlockDeduper> xmlBlockDedupers;
    private final String elementName;
    private final List<Attribute> attributes;
    private final List<XMLEvent> packageEvents = new ArrayList<XMLEvent>();
    private final boolean upgradeable;

    YumMetadataMerger(boolean upgradeable, List<XmlBlockDeduper> xmlBlockDedupers, String elementName, Map<String, String> attributes) {
        Preconditions.checkNotNull(xmlBlockDedupers);
        Preconditions.checkNotNull((Object)elementName);
        Preconditions.checkNotNull(attributes);
        this.upgradeable = upgradeable;
        this.xmlBlockDedupers = xmlBlockDedupers;
        this.elementName = elementName;
        this.attributes = this.buildAttributes(attributes);
    }

    YumMetadataMerger(List<XmlBlockDeduper> xmlBlockDedupers, String elementName, Map<String, String> attributes) {
        this(false, xmlBlockDedupers, elementName, attributes);
    }

    private List<Attribute> buildAttributes(Map<String, String> attributes) {
        return (List)attributes.entrySet().stream().map(attribute -> xmlEventFactory.createAttribute((String)attribute.getKey(), (String)attribute.getValue())).collect(ImmutableList.toImmutableList());
    }

    private void addStartElement(XMLEventWriter xmlEventWriter) throws XMLStreamException {
        xmlEventWriter.add(xmlEventFactory.createStartElement("", "", this.elementName, this.attributes.iterator(), null));
    }

    private void addEndElement(XMLEventWriter xmlEventWriter) throws XMLStreamException {
        xmlEventWriter.add(xmlEventFactory.createEndElement("", "", this.elementName));
    }

    public void merge(Path path, List<InputStreamSupplier> streams) throws IOException, XMLStreamException {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull(streams);
        if (streams.size() == 1) {
            this.copyOfInputStream(path, streams.get(0).get());
            return;
        }
        if (!this.upgradeable) {
            this.mergeStreams(path, streams);
        } else {
            this.mergeStreamsAndUpdate(path, streams);
        }
    }

    private void mergeStreamsAndUpdate(Path path, List<InputStreamSupplier> streams) throws XMLStreamException {
        Path tmpPath = null;
        try {
            try {
                tmpPath = Files.createTempFile("temp", "xml", new FileAttribute[0]);
                this.mergeStreams(tmpPath, streams);
                int packageCount = this.getPackageCount();
                this.log.debug("Total of packages: {}", (Object)packageCount);
                this.updatePackageCount(tmpPath, path, packageCount);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create temporary file", e);
            }
        }
        catch (Throwable throwable) {
            this.deleteFile(tmpPath);
            throw throwable;
        }
        this.deleteFile(tmpPath);
    }

    private void mergeStreams(Path path, List<InputStreamSupplier> streams) throws XMLStreamException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream outputStream = this.createOutputStream(path);
             XMLEventWriter xmlEventWriter = xmlOutputFactory.createXMLEventWriter(outputStream);){
            xmlEventWriter.add(xmlEventFactory.createStartDocument());
            this.addStartElement(xmlEventWriter);
            this.merge(xmlEventWriter, streams);
            this.addEndElement(xmlEventWriter);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyOfInputStream(Path path, InputStream inputStream) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                InputStream in = inputStream;
                try {
                    try (OutputStream out = this.createOutputStream(path);){
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                    if (in == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                in.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to copy when there is only one input stream", e);
        }
    }

    private void updatePackageCount(Path tmpPath, Path path, int packageCount) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(tmpPath, new OpenOption[0]));){
                SAXBuilder saxBuilder = new SAXBuilder();
                Document document = saxBuilder.build((InputStream)inputStream);
                Element root = document.getRootElement();
                root.getAttribute(PACKAGES).setValue(Integer.toString(packageCount));
                XMLOutputter xmlOutput = new XMLOutputter();
                xmlOutput.setFormat(Format.getPrettyFormat());
                Throwable throwable2 = null;
                Object var12_16 = null;
                try (OutputStream out = this.createOutputStream(path);){
                    xmlOutput.output(document, out);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | JDOMException e) {
            throw new RuntimeException("Unable to update the package count in the XML file", e);
        }
    }

    private void merge(XMLEventWriter xmlEventWriter, List<InputStreamSupplier> streams) {
        this.xmlBlockDedupers.forEach(XmlBlockDeduper::clear);
        for (InputStreamSupplier inputStream : streams) {
            XMLEventReader xmlEventReader = null;
            try {
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (InputStream in = inputStream.get();){
                        xmlEventReader = xmlInputFactory.createXMLEventReader(in);
                        XmlBlockDeduper xmlBlockDeduper = null;
                        while (xmlEventReader.hasNext()) {
                            XMLEvent xmlEvent = xmlEventReader.nextEvent();
                            if (this.isStartOfNewBlock(xmlBlockDeduper, xmlEvent)) {
                                xmlBlockDeduper = this.findDeduper(this.xmlBlockDedupers, xmlEvent);
                                if (xmlBlockDeduper == null) continue;
                                this.packageEvents.add(xmlEvent);
                                continue;
                            }
                            if (this.isEndOfCurrentBlock(xmlBlockDeduper, xmlEvent)) {
                                this.packageEvents.add(xmlEvent);
                                this.addIfUnique(xmlEventWriter, xmlBlockDeduper);
                                this.packageEvents.clear();
                                xmlBlockDeduper = null;
                                continue;
                            }
                            if (!this.isAlreadyDeduping(xmlBlockDeduper)) continue;
                            this.packageEvents.add(xmlBlockDeduper.process(xmlEvent));
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | XMLStreamException e) {
                    this.log.error("Error at time to merge {} streams for metadata files", (Object)streams.size());
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                this.close(xmlEventReader);
                throw throwable;
            }
            this.close(xmlEventReader);
        }
        this.xmlBlockDedupers.forEach(deduper -> deduper.postProcess(xmlEventWriter));
    }

    private int getPackageCount() {
        return this.xmlBlockDedupers.stream().mapToInt(XmlBlockDeduper::uniqueBlockCount).sum();
    }

    private boolean isAlreadyDeduping(XmlBlockDeduper xmlBlockDeduper) {
        return xmlBlockDeduper != null;
    }

    private void addIfUnique(XMLEventWriter xmlEventWriter, XmlBlockDeduper xmlBlockDeduper) {
        if (xmlBlockDeduper.isUnique(this.packageEvents)) {
            for (XMLEvent packageEvent : this.packageEvents) {
                try {
                    xmlEventWriter.add(packageEvent);
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void close(XMLEventReader xmlEventReader) {
        if (xmlEventReader != null) {
            try {
                xmlEventReader.close();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Unable to close the xmlEventReader", e);
            }
        }
    }

    @Nullable
    private XmlBlockDeduper findDeduper(List<XmlBlockDeduper> xmlBlockDedupers, XMLEvent xmlEvent) {
        return xmlBlockDedupers.stream().filter(deduper -> deduper.isBlockStart(xmlEvent)).findFirst().orElse(null);
    }

    private boolean isStartOfNewBlock(@Nullable XmlBlockDeduper xmlBlockDeduper, XMLEvent xmlEvent) {
        return xmlBlockDeduper == null && xmlEvent.isStartElement();
    }

    private boolean isEndOfCurrentBlock(@Nullable XmlBlockDeduper xmlBlockDeduper, XMLEvent xmlEvent) {
        return xmlBlockDeduper != null && xmlBlockDeduper.isBlockEnd(xmlEvent);
    }

    private OutputStream createOutputStream(Path path) throws IOException {
        BufferedOutputStream fileOutputStream = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));
        if (path.toAbsolutePath().toString().endsWith("xml.gz")) {
            return new GZIPOutputStream(fileOutputStream);
        }
        return fileOutputStream;
    }

    private void deleteFile(Path path) {
        if (path != null) {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                this.log.error("Unable to delete {}", (Object)path, (Object)e);
            }
        }
    }
}

