/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.mergerepo;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.yum.internal.mergerepo.YumMergeService;
import org.sonatype.nexus.repository.yum.internal.mergerepo.YumMetadataMerger;
import org.sonatype.nexus.repository.yum.internal.mergerepo.YumMetadataMergerFactory;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadataType;

@Named
@Singleton
public class YumMergeServiceImpl
extends ComponentSupport
implements YumMergeService {
    private final YumMetadataMergerFactory mergers;

    @Inject
    public YumMergeServiceImpl(YumMetadataMergerFactory mergers) {
        Preconditions.checkNotNull((Object)mergers);
        this.mergers = mergers;
    }

    @Override
    public void merge(YumMetadataType metadataType, Path path, List<InputStreamSupplier> streams) {
        Preconditions.checkNotNull((Object)((Object)metadataType));
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull(streams);
        Preconditions.checkArgument((!streams.isEmpty() ? 1 : 0) != 0);
        try {
            YumMetadataMerger merger = this.getYumMetadataMerger(metadataType);
            this.generateMergedFile(path, merger, streams);
        }
        catch (IOException e) {
            this.log.warn("Unable to merge metadata for {}", (Object)metadataType.getType(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private YumMetadataMerger getYumMetadataMerger(YumMetadataType metadataType) {
        YumMetadataMerger merger = this.mergers.getMetadataMerger(metadataType.getType());
        Preconditions.checkNotNull((Object)((Object)merger));
        return merger;
    }

    private void generateMergedFile(Path path, YumMetadataMerger merger, List<InputStreamSupplier> streams) throws IOException {
        this.log.debug("Total of files to merge: {}", (Object)streams.size());
        try {
            merger.merge(path, streams);
        }
        catch (XMLStreamException e) {
            this.log.warn("Unable to process xml data", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

