/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.mergerepo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.sonatype.nexus.repository.yum.internal.mergerepo.XmlBlockDeduper;

public final class LangPacksXmlBlockDeduper
extends XmlBlockDeduper {
    private static final XMLEventFactory xmlEventFactory = XMLEventFactory.newInstance();
    private static final String LANGPACKS_TAG = "langpacks";
    private static final String MATCH_TAG = "match";
    private static final String NAME_ATTRIBUTE = "name";
    private Map<String, XMLEvent> eventMap = new HashMap<String, XMLEvent>();

    public LangPacksXmlBlockDeduper() {
        super(LANGPACKS_TAG);
    }

    @Override
    public XMLEvent process(XMLEvent xmlEvent) {
        if (xmlEvent.isStartElement() && MATCH_TAG.equals(xmlEvent.asStartElement().getName().getLocalPart())) {
            Attribute attribute = xmlEvent.asStartElement().getAttributeByName(new QName(NAME_ATTRIBUTE));
            this.eventMap.put(attribute.getValue(), xmlEvent);
        }
        return xmlEvent;
    }

    @Override
    public void postProcess(XMLEventWriter xmlEventWriter) {
        try {
            try {
                xmlEventWriter.add(xmlEventFactory.createStartElement(new QName(LANGPACKS_TAG), null, null));
                this.processEachElement(xmlEventWriter);
                xmlEventWriter.add(xmlEventFactory.createEndElement(new QName(LANGPACKS_TAG), null));
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.eventMap.clear();
        }
    }

    private void processEachElement(XMLEventWriter xmlEventWriter) {
        this.eventMap.forEach((key, xmlEvent) -> {
            try {
                xmlEventWriter.add((XMLEvent)xmlEvent);
                xmlEventWriter.add(xmlEventFactory.createEndElement(new QName(MATCH_TAG), null));
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public boolean isUnique(List<XMLEvent> xmlEvents) {
        return false;
    }
}

