/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.httpclient;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.httpclient.ContentCompressionStrategy;

@Named(value="yum")
@Singleton
public class YumContentCompressionStrategy
implements ContentCompressionStrategy {
    private Set<String> disableCompressionRepos;

    @Inject
    public YumContentCompressionStrategy(@Named(value="${nexus.yum.content.compression.disable.strategy:-}") @Named(value="${nexus.yum.content.compression.disable.strategy:-}") String disableCompressionRepos) {
        this.disableCompressionRepos = new HashSet<String>(Arrays.asList(disableCompressionRepos.split(",")));
    }

    public boolean shouldDisableContentCompression(String repositoryName) {
        return this.disableCompressionRepos.contains(repositoryName);
    }
}

