/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.group;

import java.io.IOException;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.MergingGroupHandlerSupport;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupFacet;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;

public abstract class YumMergingGroupHandlerSupport
extends MergingGroupHandlerSupport {
    protected abstract String basePath(TokenMatcher.State var1);

    @Inject
    public void injectDependencies(Cooperation2Factory cooperationFactory, @Named(value="${nexus.repomd.cooperation.enabled:-true}") @Named(value="${nexus.repomd.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.repomd.cooperation.majorTimeout:-0s}") @Named(value="${nexus.repomd.cooperation.majorTimeout:-0s}") Duration majorTimeout, @Named(value="${nexus.repomd.cooperation.minorTimeout:-30s}") @Named(value="${nexus.repomd.cooperation.minorTimeout:-30s}") Duration minorTimeout, @Named(value="${nexus.repomd.cooperation.threadsPerKey:-100}") @Named(value="${nexus.repomd.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        this.configureCooperation(cooperationFactory, cooperationEnabled, majorTimeout, minorTimeout, threadsPerKey);
    }

    protected String[] cooperationKey(Context context) {
        return new String[]{context.getRequest().getPath()};
    }

    protected Optional<Content> merge(Context context, Map<Repository, Response> successfulResponses, Optional<String> etag) throws IOException {
        Map inputStreamMap = successfulResponses.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, YumMergingGroupHandlerSupport::toInputStreamSupplier, YumMergingGroupHandlerSupport.throwingMerger(), LinkedHashMap::new));
        Content content = this.facet(context).buildRepomd(this.basePath(YumPathUtils.matcherState(context)), inputStreamMap, context, etag);
        return Optional.ofNullable(content);
    }

    protected Optional<Content> getCached(Context context) {
        YumGroupFacet facet = this.facet(context);
        return Optional.ofNullable(facet.get(YumMergingGroupHandlerSupport.getPath(context))).filter(content -> !facet.isStale((Content)content));
    }

    private static String getPath(Context context) {
        return context.getRequest().getPath();
    }

    protected YumGroupFacet facet(Context context) {
        return (YumGroupFacet)context.getRepository().facet(YumGroupFacet.class);
    }

    private static InputStreamSupplier toInputStreamSupplier(Map.Entry<?, Response> response) {
        return () -> ((Response)response.getValue()).getPayload().openInputStream();
    }

    protected boolean shouldReturnOnlyRespondingMember(Repository repository) {
        return false;
    }
}

