/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.group;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.common.io.SafeXml;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRepomdParser;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRequest;
import org.sonatype.nexus.repository.yum.internal.metadata.RepomdParser;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadataType;
import org.w3c.dom.Document;

@Singleton
@Named
public class YumGroupRepomdParserImpl
extends ComponentSupport
implements YumGroupRepomdParser {
    private final RepomdParser repomdParser;
    private final DocumentBuilderFactory documentBuilderFactory;

    @Inject
    public YumGroupRepomdParserImpl(RepomdParser repomdParser) throws ParserConfigurationException {
        this.repomdParser = (RepomdParser)Preconditions.checkNotNull((Object)repomdParser);
        this.documentBuilderFactory = SafeXml.newdocumentBuilderFactory();
        this.documentBuilderFactory.setValidating(false);
    }

    @Override
    public Map<YumMetadataType, List<YumGroupRequest>> parse(Map<Repository, InputStreamSupplier> repositoriesResponseMap) {
        HashMap<YumMetadataType, List<YumGroupRequest>> metadataTypeListMap = new HashMap<YumMetadataType, List<YumGroupRequest>>();
        repositoriesResponseMap.forEach((repository, resp) -> {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream response = resp.get();){
                    this.transposeMetadataFromResponse((Map<YumMetadataType, List<YumGroupRequest>>)metadataTypeListMap, (Repository)repository, response);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.log.warn("Unable to convert response from repository {} to xml document", (Object)repository.getName(), (Object)e);
            }
        });
        return metadataTypeListMap;
    }

    private void transposeMetadataFromResponse(Map<YumMetadataType, List<YumGroupRequest>> metadataTypeListMap, Repository repository, InputStream response) throws Exception {
        Document document = this.responseToDocument(response);
        Map<YumMetadataType, YumMetadata> metadataList = this.dedupeComps(this.repomdParser.parseAll(document));
        metadataList.forEach((metadataType, metadata) -> {
            metadataTypeListMap.computeIfAbsent((YumMetadataType)((Object)metadataType), key -> new ArrayList());
            ((List)metadataTypeListMap.get(metadataType)).add(new YumGroupRequest(repository, metadata.getLocation()));
        });
    }

    private Map<YumMetadataType, YumMetadata> dedupeComps(Map<YumMetadataType, YumMetadata> metadataMap) {
        if (metadataMap.containsKey((Object)YumMetadataType.COMPS) && metadataMap.containsKey((Object)YumMetadataType.COMPS_GZ)) {
            metadataMap.remove((Object)YumMetadataType.COMPS);
        } else if (metadataMap.containsKey((Object)YumMetadataType.COMPS)) {
            YumMetadata originalMetadata = metadataMap.remove((Object)YumMetadataType.COMPS);
            metadataMap.put(YumMetadataType.COMPS_GZ, originalMetadata);
        }
        return metadataMap;
    }

    private Document responseToDocument(InputStream response) throws Exception {
        DocumentBuilder builder = this.documentBuilderFactory.newDocumentBuilder();
        return builder.parse(response);
    }
}

