/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.group;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataFile;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupMerger;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRequest;
import org.sonatype.nexus.repository.yum.internal.mergerepo.YumMergeService;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadataType;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;

@Singleton
@Named
public class YumGroupMergerImpl
extends ComponentSupport
implements YumGroupMerger {
    private final YumMergeService yumMergeService;

    @Inject
    public YumGroupMergerImpl(YumMergeService yumMergeService) {
        this.yumMergeService = (YumMergeService)Preconditions.checkNotNull((Object)yumMergeService);
    }

    @Override
    public List<YumMetadataFile> fetchAndMergeMetadata(String path, Map<YumMetadataType, List<YumGroupRequest>> metadataTypes, Context context) {
        return metadataTypes.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry<YumMetadataType, List<InputStreamSupplier>>((YumMetadataType)((Object)((Object)entry.getKey())), this.fetch(path, (List)entry.getValue(), context))).filter(tuple -> !((List)tuple.getValue()).isEmpty()).map(tuple -> this.mergeResponses((YumMetadataType)((Object)((Object)tuple.getKey())), (List)tuple.getValue())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<InputStreamSupplier> fetch(String path, List<YumGroupRequest> groupRequests, Context context) {
        ArrayList<InputStreamSupplier> responseStreams = new ArrayList<InputStreamSupplier>();
        groupRequests.forEach(request -> {
            this.log.info("Requesting {} from {}", (Object)request.getLocation(), (Object)request.getRepository().getName());
            ViewFacet view = (ViewFacet)request.getRepository().facet(ViewFacet.class);
            try {
                Request requestToMember = this.buildRequest(path, request.getLocation(), context);
                Response response = view.dispatch(requestToMember, context);
                if (response.getStatus().getCode() == 200 && response.getPayload() != null) {
                    responseStreams.add(() -> YumMetadataUtils.xmlInputStream(request.getLocation(), response.getPayload().openInputStream()));
                }
            }
            catch (Exception e) {
                this.log.warn("Unable to dispatch get request of {} to {}", new Object[]{request.getLocation(), request.getRepository().getName(), e});
            }
        });
        return responseStreams;
    }

    private Request buildRequest(String path, String filename, Context originalContext) {
        return new Request.Builder().action("GET").path(StringUtils.prependIfMissing((String)YumPathUtils.appendPath(path, filename), (CharSequence)"/", (CharSequence[])new CharSequence[0])).attributes(originalContext.getRequest().getAttributes()).headers(originalContext.getRequest().getHeaders()).build();
    }

    @Nullable
    private YumMetadataFile mergeResponses(YumMetadataType metadataType, List<InputStreamSupplier> streams) {
        Path path = null;
        String resultFile = String.valueOf(metadataType.getType()) + "." + metadataType.getFileType();
        try {
            path = Files.createTempFile(metadataType.getType(), metadataType.getFileType(), new FileAttribute[0]);
            this.log.info("Merge of {} starting", (Object)resultFile);
            this.yumMergeService.merge(metadataType, path, streams);
            this.log.info("Merge of {} completed", (Object)resultFile);
            return new YumMetadataFile(metadataType, path);
        }
        catch (IOException e) {
            this.log.error("Unable to create gzip outputstream of {}", (Object)resultFile, (Object)e);
            this.deleteFile(path);
            return null;
        }
    }

    private void deleteFile(Path path) {
        if (path != null) {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                this.log.error("Unable to delete {}", (Object)path, (Object)e);
            }
        }
    }
}

