/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.group;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.internal.gpg.YumSigningFacet;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupFacet;

@Named
@Singleton
public class YumGroupHandler
extends GroupHandler {
    protected Response doGet(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) throws Exception {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        if (assetKind == AssetKind.REPOMD_ASC) {
            Repository repository = context.getRepository();
            YumSigningFacet signingFacet = (YumSigningFacet)repository.facet(YumSigningFacet.class);
            Optional<Content> metadataSignature = signingFacet.maybeSignRepoMetadata(context, repository);
            if (metadataSignature.isPresent()) {
                return YumGroupHandler.generateResponse(metadataSignature.get());
            }
            return super.doGet(context, dispatched);
        }
        if (assetKind == AssetKind.RPM || assetKind == AssetKind.NON_YUM) {
            return super.doGet(context, dispatched);
        }
        Content groupContent = YumGroupHandler.getContent(context);
        if (groupContent != null) {
            return YumGroupHandler.generateResponse(groupContent);
        }
        return super.doGet(context, dispatched);
    }

    @Nullable
    private static Content getContent(Context context) {
        return YumGroupHandler.getGroupFacet(context).get(YumGroupHandler.getPath(context));
    }

    private static YumGroupFacet getGroupFacet(Context context) {
        return (YumGroupFacet)context.getRepository().facet(YumGroupFacet.class);
    }

    private static String getPath(Context context) {
        return context.getRequest().getPath();
    }

    private static Response generateResponse(@Nullable Content content) {
        return Optional.ofNullable(content).map(HttpResponses::ok).orElseGet(HttpResponses::notFound);
    }
}

