/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.gpg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.groups.Default;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.security.GpgUtils;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.internal.metadata.MetadataSignatureStorage;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;

@Named
@Facet.Exposed
public class YumSigningFacet
extends FacetSupport {
    @VisibleForTesting
    static final String CONFIG_KEY = "yumSigning";
    private GpgUtils.SigningConfig config;
    private final MetadataSignatureStorage metadataStorage;

    @Inject
    public YumSigningFacet(MetadataSignatureStorage metadataStorage) {
        this.metadataStorage = (MetadataSignatureStorage)Preconditions.checkNotNull((Object)metadataStorage);
    }

    protected void doValidate(Configuration configuration) throws Exception {
        ((ConfigurationFacet)this.facet(ConfigurationFacet.class)).validateSection(configuration, CONFIG_KEY, GpgUtils.SigningConfig.class, new Class[]{Default.class, this.getRepository().getType().getValidationGroup()});
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        this.config = this.readSigningConfig(configuration);
    }

    protected void doDestroy() throws Exception {
        this.config = null;
    }

    public Optional<Content> maybeSignRepoMetadata(Context context, Repository repository) throws IOException {
        if (this.isRepoMetadataSignature(context) && GpgUtils.isConfigured((String)this.config.getKeypair(), (String)this.config.getPassphrase())) {
            TokenMatcher.State matcherState = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            String assetPath = YumPathUtils.buildAssetPath(matcherState);
            return this.signRepomd(assetPath, repository);
        }
        return Optional.empty();
    }

    public GpgUtils.SigningConfig readSigningConfig(Configuration configuration) {
        return (GpgUtils.SigningConfig)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, CONFIG_KEY, GpgUtils.SigningConfig.class);
    }

    private boolean isRepoMetadataSignature(Context context) {
        return AssetKind.REPOMD_ASC.equals(context.getAttributes().require(AssetKind.class));
    }

    private Optional<Content> signRepomd(String assetPath, Repository repository) throws IOException {
        String metadataPath = assetPath.substring(0, assetPath.lastIndexOf(46));
        Content metadataContent = this.metadataStorage.get(repository, metadataPath);
        if (metadataContent != null) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (InputStream is = metadataContent.openInputStream();){
                byte[] signedContent = GpgUtils.signExternal((InputStream)is, (String)this.config.getKeypair(), (String)this.config.getPassphrase());
                BytesPayload signPayload = new BytesPayload(signedContent, "application/pgp-signature");
                Content signContent = new Content((Payload)signPayload);
                return Optional.of(this.metadataStorage.save(repository, assetPath, signContent));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return Optional.empty();
    }
}

