/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.createrepo;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.yum.AssetKind;

public class MetadataBlob {
    private final Path tempFile;
    private final String path;
    private final String contentType;
    private final AssetKind assetKind;
    private final long expectedRpmCount;

    public MetadataBlob(Path tempFile, String path, String contentType, AssetKind assetKind, long expectedRpmCount) {
        this.tempFile = (Path)Preconditions.checkNotNull((Object)tempFile);
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.contentType = (String)Preconditions.checkNotNull((Object)contentType);
        this.assetKind = (AssetKind)((Object)Preconditions.checkNotNull((Object)((Object)assetKind)));
        this.expectedRpmCount = expectedRpmCount;
    }

    public InputStreamSupplier getInputStreamSupplier() {
        return () -> new BufferedInputStream(Files.newInputStream(this.tempFile, StandardOpenOption.READ));
    }

    public long getSize() throws IOException {
        return Files.size(this.tempFile);
    }

    public String getPath() {
        return this.path;
    }

    public String getContentType() {
        return this.contentType;
    }

    public AssetKind getAssetKind() {
        return this.assetKind;
    }

    public long getExpectedRpmCount() {
        return this.expectedRpmCount;
    }
}

