/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.createrepo;

import com.google.common.collect.ImmutableMap;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.text.StringEscapeUtils;
import org.sonatype.nexus.repository.yum.internal.createrepo.MetadataWriter;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpm;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmFile;

public abstract class FilesMetadataWriter
extends MetadataWriter<YumRpm> {
    public FilesMetadataWriter(OutputStream out) throws XMLStreamException {
        super(out);
    }

    protected void writeFiles(@Nullable List<YumRpmFile> files, Predicate<YumRpmFile> predicate) throws XMLStreamException {
        if (files != null) {
            Map<String, List<YumRpmFile>> primaryFiles = files.stream().filter(predicate).collect(Collectors.groupingBy(YumRpmFile::getType));
            this.writeFilesByType(primaryFiles, YumRpm.FileType.FILE);
            this.writeFilesByType(primaryFiles, YumRpm.FileType.DIR);
            this.writeFilesByType(primaryFiles, YumRpm.FileType.GHOST);
        }
    }

    private void writeFilesByType(Map<String, List<YumRpmFile>> primaryFiles, YumRpm.FileType type) throws XMLStreamException {
        if (primaryFiles.containsKey(type.name().toLowerCase())) {
            for (YumRpmFile file : primaryFiles.get(type.name().toLowerCase())) {
                if (type == YumRpm.FileType.FILE) {
                    this.writeElement("file", StringEscapeUtils.escapeXml10((String)file.getName()));
                    continue;
                }
                this.writeElement("file", (Object)file.getName(), (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)file.getType()));
            }
        }
    }
}

