/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadFieldDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;
import org.sonatype.nexus.repository.upload.UploadRegexMap;
import org.sonatype.nexus.repository.upload.ValidatingComponentUpload;

public abstract class YumUploadHandlerSupport
extends UploadHandlerSupport {
    public static final String DIRECTORY = "directory";
    public static final String FILENAME = "filename";
    private final VariableResolverAdapter variableResolverAdapter;
    private final ContentPermissionChecker contentPermissionChecker;

    protected YumUploadHandlerSupport(Set<UploadDefinitionExtension> uploadDefinitionExtensions, VariableResolverAdapter variableResolverAdapter, ContentPermissionChecker contentPermissionChecker) {
        super(uploadDefinitionExtensions);
        this.variableResolverAdapter = Objects.requireNonNull(variableResolverAdapter);
        this.contentPermissionChecker = Objects.requireNonNull(contentPermissionChecker);
    }

    public UploadDefinition getDefinition() {
        UploadRegexMap regexMap = new UploadRegexMap("(.*)$", new String[]{FILENAME});
        return this.getDefinition("yum", false, Collections.singletonList(new UploadFieldDefinition(DIRECTORY, "Directory", null, true, UploadFieldDefinition.Type.STRING, "Location")), Collections.singletonList(new UploadFieldDefinition(FILENAME, "Filename", null, false, UploadFieldDefinition.Type.STRING, null)), regexMap);
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }

    public ValidatingComponentUpload getValidatingComponentUpload(ComponentUpload componentUpload) {
        return new ValidatingComponentUpload(this.getDefinition(), componentUpload);
    }

    public static String buildAssetPath(ComponentUpload upload) {
        AssetUpload asset = (AssetUpload)upload.getAssetUploads().get(0);
        StringBuilder assetPath = new StringBuilder();
        String directory = upload.getField(DIRECTORY);
        if (!Strings2.isBlank((String)directory)) {
            assetPath.append(directory);
            if (assetPath.charAt(assetPath.length() - 1) != '/') {
                assetPath.append('/');
            }
        }
        assetPath.append(asset.getField(FILENAME));
        return assetPath.toString();
    }
}

