/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal;

import com.google.common.annotations.VisibleForTesting;
import javax.validation.constraints.NotNull;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.InvalidContentException;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.yum.DeployPolicy;

public abstract class YumHostedFacetSupport
extends FacetSupport {
    public static final String METADATA_GENERATION_TIME = "metadata_generation_time";
    public static final String RPMS_REMOVED_ATTRIBUTE_VALUE = "rpms_removed";
    protected Config config;

    public Integer getRepodataDepth() {
        return this.config.repodataDepth;
    }

    public DeployPolicy getDeployPolicy() {
        return this.config.deployPolicy;
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        super.doConfigure(configuration);
        Config config = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, "yum", Config.class);
        this.setConfig(config);
    }

    public void validateRepodataDepth(String path) {
        Integer repodataDepth;
        int depth = this.getPathDepth(path);
        if (depth < (repodataDepth = this.getRepodataDepth())) {
            throw new InvalidContentException(String.format("Uploading RPMs above the configured depth is not allowed. Repodata depth set to %d, RPM depth is lower (%d)", repodataDepth, depth));
        }
    }

    protected int getPathDepth(String path) {
        return path.split("/").length - 1;
    }

    @VisibleForTesting
    public void setConfig(Config config) {
        this.config = config;
        this.log.debug("Config: {}", (Object)config);
    }

    @VisibleForTesting
    public static class Config {
        public Integer repodataDepth = 0;
        @NotNull(groups={HostedType.ValidationGroup.class})
        public DeployPolicy deployPolicy;

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "repodataDepth=" + this.repodataDepth + ", deployPolicy=" + (Object)((Object)this.deployPolicy) + '}';
        }
    }
}

