/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.migration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.yum.datastore.internal.data.YumKeyValueFacet;
import org.sonatype.nexus.repository.yum.internal.YumFormat;
import org.sonatype.nexus.scheduling.PeriodicJobService;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
public class YumMetadataInfoMigration
extends StateGuardLifecycleSupport {
    private final PeriodicJobService periodicJobService;
    private final RepositoryManager repositoryManager;
    private final Duration migrationDelay;
    private final TaskScheduler taskScheduler;
    public static final String PRIME_YUM_METADATA_CACHE = "Prime yum metadata cache";
    private static final Pattern TASK_WITH_NAMES_PATTERN = Pattern.compile("Prime yum metadata cache - \\((.*?)\\)");

    @Inject
    public YumMetadataInfoMigration(PeriodicJobService periodicJobService, TaskScheduler scheduler, RepositoryManager repositoryManager, @Named(value="${nexus.yum.metadata.migrate.delay:-60s}") @Named(value="${nexus.yum.metadata.migrate.delay:-60s}") Duration migrationDelay) {
        this.periodicJobService = (PeriodicJobService)Preconditions.checkNotNull((Object)periodicJobService);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.migrationDelay = (Duration)Preconditions.checkNotNull((Object)migrationDelay);
        Preconditions.checkArgument((!migrationDelay.isNegative() ? 1 : 0) != 0, (Object)"Non-negative nexus.yum.metadata.migrate.delay required");
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)scheduler);
    }

    protected void doStart() {
        this.invoke(() -> ((PeriodicJobService)this.periodicJobService).startUsing());
        this.periodicJobService.runOnce(() -> {
            this.migrate();
            this.invoke(() -> ((PeriodicJobService)this.periodicJobService).stopUsing());
        }, (int)this.migrationDelay.getSeconds());
    }

    public void migrate() {
        this.log.debug("Migrate non-existing RPMs metadata from files to DB.");
        List<String> repositoryList = this.listYumHostedRepositories().filter(YumMetadataInfoMigration::isEmpty).filter(this::taskMissing).map(Repository::getName).collect(Collectors.toList());
        if (repositoryList.isEmpty()) {
            return;
        }
        this.scheduleTask(repositoryList);
    }

    @VisibleForTesting
    Stream<Repository> listYumHostedRepositories() {
        return StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).filter(repository -> repository.getFormat() instanceof YumFormat).filter(repository -> repository.getType() instanceof HostedType);
    }

    @VisibleForTesting
    void scheduleTask(List<String> repositories) {
        TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("repository.yum.rebuild.metadata");
        String repositoryNames = String.join((CharSequence)",", repositories);
        configuration.setString("repositoryName", repositoryNames);
        configuration.setBoolean("yumMetadataCaching", false);
        configuration.setName(YumMetadataInfoMigration.taskName(repositoryNames));
        this.taskScheduler.submit(configuration);
    }

    private static String taskName(String repositoryNames) {
        return String.format("%s - (%s)", PRIME_YUM_METADATA_CACHE, repositoryNames);
    }

    private boolean taskMissing(Repository repository) {
        String repositoryName = repository.getName();
        return this.taskScheduler.listsTasks().stream().map(TaskInfo::getName).noneMatch(taskName -> YumMetadataInfoMigration.isRepoInTask(taskName, repositoryName));
    }

    @VisibleForTesting
    static boolean isRepoInTask(String taskName, String repositoryName) {
        Matcher matcher = TASK_WITH_NAMES_PATTERN.matcher(taskName);
        return matcher.find() && matcher.group(1).contains(repositoryName);
    }

    private static boolean isEmpty(Repository repository) {
        return ((YumKeyValueFacet)repository.facet(YumKeyValueFacet.class)).browseRepoLocations().isEmpty();
    }

    private void invoke(ThrowingRunnable callable) {
        try {
            callable.run();
        }
        catch (Exception e) {
            this.log.debug("Failed to start or stop using the PeriodicJobService", (Throwable)e);
        }
    }

    @FunctionalInterface
    private static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

