/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal.group;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.cache.RepositoryCacheInvalidationService;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.group.GroupFacetImpl;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.PathPayload;
import org.sonatype.nexus.repository.yum.datastore.YumContentFacet;
import org.sonatype.nexus.repository.yum.datastore.internal.database.YumQueryGroupComponent;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataFile;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupFacet;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupMerger;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRepomdCreator;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRepomdParser;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRequest;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadataType;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
@Facet.Exposed
public class YumGroupFacetImpl
extends GroupFacetImpl
implements YumGroupFacet {
    private final YumGroupRepomdCreator groupRepomdCreator;
    private final YumGroupMerger groupMerger;
    private final YumGroupRepomdParser groupRepomdParser;
    private final YumQueryGroupComponent yumQueryGroupComponent;

    @Inject
    public YumGroupFacetImpl(RepositoryManager repositoryManager, ConstraintViolationFactory constraintViolationFactory, @Named(value="group") @Named(value="group") Type groupType, YumGroupRepomdCreator groupRepomdCreator, YumGroupMerger groupMerger, YumGroupRepomdParser groupRepomdParser, YumQueryGroupComponent yumQueryGroupComponent, RepositoryCacheInvalidationService repositoryCacheInvalidationService) {
        super(repositoryManager, constraintViolationFactory, groupType, repositoryCacheInvalidationService);
        this.groupRepomdCreator = (YumGroupRepomdCreator)Preconditions.checkNotNull((Object)groupRepomdCreator);
        this.groupMerger = (YumGroupMerger)Preconditions.checkNotNull((Object)groupMerger);
        this.groupRepomdParser = (YumGroupRepomdParser)Preconditions.checkNotNull((Object)groupRepomdParser);
        this.yumQueryGroupComponent = (YumQueryGroupComponent)((Object)Preconditions.checkNotNull((Object)((Object)yumQueryGroupComponent)));
    }

    @Override
    @Nullable
    public Content buildRepomd(String path, Map<Repository, InputStreamSupplier> repositoriesResponseMap, Context context, Optional<String> optEtag) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull(repositoriesResponseMap);
        Preconditions.checkNotNull((Object)context);
        if (repositoriesResponseMap.isEmpty()) {
            this.log.debug("Unable to create metadata for repository {}. Members had no metadata to merge.", (Object)context.getRepository().getName());
            return null;
        }
        this.log.info("Creating latest metadata by merging metadata of group members for repository {}", (Object)context.getRepository().getName());
        List<YumMetadataFile> metadataCollection = Collections.emptyList();
        Map<YumMetadataType, List<YumGroupRequest>> repodataFiles = this.groupRepomdParser.parse(repositoriesResponseMap);
        try {
            metadataCollection = this.groupMerger.fetchAndMergeMetadata(path, repodataFiles, context);
            YumMetadataFile repomdFile = this.groupRepomdCreator.create(metadataCollection);
            if (repomdFile != null) {
                metadataCollection.add(repomdFile);
            }
            String repodataPath = StringUtils.prependIfMissing((String)YumPathUtils.getRepodataPath(path), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            Content content = this.saveAllAndDiscardUnused(metadataCollection, repodataPath, optEtag);
            return content;
        }
        finally {
            this.cleanupFiles(metadataCollection);
        }
    }

    @Override
    @Nullable
    public Content get(String requestPath) {
        return this.content().get(StringUtils.prependIfMissing((String)requestPath, (CharSequence)"/", (CharSequence[])new CharSequence[0])).map(FluentAsset::download).orElse(null);
    }

    public List<Repository> leafMembers() {
        List repositories = super.leafMembers();
        repositories.add(0, this.getRepository());
        return repositories;
    }

    @Nullable
    private Content saveAllAndDiscardUnused(List<YumMetadataFile> metadataCollection, String path, Optional<String> optEtag) {
        ArrayList currentMetadata = Lists.newArrayList(this.retrieveCurrentMetadata(path));
        List<Asset> savedAssets = this.saveMetadata(metadataCollection, path, optEtag);
        this.discardUnusedMetadata(currentMetadata, savedAssets);
        return this.content().get(YumPathUtils.appendPath(path, "repomd.xml")).map(FluentAsset::download).orElse(null);
    }

    protected Iterable<FluentAsset> retrieveCurrentMetadata(String path) {
        return this.yumQueryGroupComponent.findMetadataByPathPrefix(path, this.getRepository());
    }

    private void discardUnusedMetadata(List<Asset> currentMetadata, List<Asset> newMetadata) {
        FluentAssets assets = this.content().assets();
        currentMetadata.stream().filter(metadata -> this.doesntExistIn((Asset)metadata, newMetadata)).map(arg_0 -> ((FluentAssets)assets).with(arg_0)).forEach(FluentAsset::delete);
    }

    private boolean doesntExistIn(Asset currentMeta, List<Asset> newMetadata) {
        return newMetadata.stream().noneMatch(newMeta -> newMeta.path().equals(currentMeta.path()));
    }

    private List<Asset> saveMetadata(List<YumMetadataFile> metadataCollection, String path, Optional<String> optEtag) {
        try {
            ArrayList<Asset> savedAssets = new ArrayList<Asset>();
            for (YumMetadataFile yumMetadataFile : metadataCollection) {
                Asset asset = this.save(path, yumMetadataFile, optEtag);
                savedAssets.add(asset);
            }
            return savedAssets;
        }
        catch (IOException e) {
            this.log.error("Unable to save metadata to {}", (Object)path, (Object)e);
            return Collections.emptyList();
        }
    }

    private void cleanupFiles(List<YumMetadataFile> metadataCollection) {
        metadataCollection.forEach(file -> {
            try {
                String filePath;
                Path path;
                if (Objects.nonNull(file) && Objects.nonNull(path = file.getPath()) && Objects.nonNull(filePath = path.toString()) && !filePath.isEmpty()) {
                    Files.deleteIfExists(path);
                }
            }
            catch (IOException e) {
                this.log.error("Unable to delete {}", (Object)file.getPath(), (Object)e);
            }
        });
    }

    private Asset save(String path, YumMetadataFile yumGroupFile, Optional<String> optEtag) throws IOException {
        YumMetadata yumMetadata = this.getYumMetadata(yumGroupFile);
        Content content = new Content(this.toPayload(yumGroupFile, yumMetadata));
        this.maintainCacheInfo(content.getAttributes());
        optEtag.ifPresent(etag -> {
            Object object = content.getAttributes().set("etag", etag);
        });
        Content result = this.content().put(this.buildPath(path, yumMetadata), (Payload)content, yumGroupFile.getType().getKind());
        return (Asset)result.getAttributes().require(Asset.class);
    }

    private YumMetadata getYumMetadata(YumMetadataFile yumGroupFile) throws IOException {
        YumMetadata yumMetadata = yumGroupFile.getType() == YumMetadataType.REPOMD ? new YumMetadata(YumMetadataType.REPOMD) : YumMetadataUtils.readCompressedMetadata(yumGroupFile);
        return yumMetadata;
    }

    private Payload toPayload(YumMetadataFile yumGroupFile, YumMetadata yumMetadata) {
        try {
            return new PathPayload(yumGroupFile.getPath(), this.getContentType(yumMetadata));
        }
        catch (Exception e) {
            this.log.debug("An error occurred creating PathPayload for {} {}", new Object[]{yumGroupFile, yumMetadata, e});
            return new PathPayload(yumGroupFile.getPath(), null);
        }
    }

    private String getContentType(YumMetadataType yumMetadataType) {
        return yumMetadataType.getFileType().equals("xml") ? "application/xml" : "application/gzip";
    }

    private String getContentType(YumMetadata yumMetadata) {
        return this.getContentType(yumMetadata.getType());
    }

    private String buildPath(String basePath, YumMetadata yumMetadata) {
        String filename = this.getFilename(yumMetadata) + this.getExtension(yumMetadata);
        if (basePath.endsWith("/")) {
            return String.valueOf(basePath) + filename;
        }
        return String.valueOf(basePath) + "/" + filename;
    }

    private String getFilename(YumMetadata yumMetadata) {
        String type = yumMetadata.getType().getType();
        if (type.equals(YumMetadataType.COMPS.getType()) || type.equals(YumMetadataType.COMPS_GZ.getType())) {
            return "comps";
        }
        if (type.equals(YumMetadataType.REPOMD.getType())) {
            return type;
        }
        return String.valueOf(yumMetadata.getChecksum()) + "-" + type;
    }

    private String getExtension(YumMetadata yumMetadata) {
        return "." + yumMetadata.getType().getFileType();
    }

    private YumContentFacet content() {
        return (YumContentFacet)this.getRepository().facet(YumContentFacet.class);
    }
}

