/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal.database;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.yum.datastore.YumContentFacet;

@Named
@Singleton
public class YumQueryGroupComponent
extends ComponentSupport {
    public Iterable<FluentAsset> findMetadataByPathPrefix(String pathPrefix, Repository repository) {
        YumContentFacet facet = (YumContentFacet)repository.facet(YumContentFacet.class);
        String filter = "repository_id = #{filterParams.repositoryParam} AND path LIKE #{filterParams.pathParam} AND component_id IS NULL";
        ImmutableMap params = ImmutableMap.of((Object)"repositoryParam", (Object)facet.contentRepositoryId(), (Object)"pathParam", (Object)(String.valueOf(pathPrefix) + "%"));
        return Continuations.iterableOf((arg_0, arg_1) -> ((FluentQuery)facet.assets().byFilter(filter, (Map)params)).browse(arg_0, arg_1));
    }

    public Optional<FluentAsset> findRepomdOnPath(Repository repository, String path) {
        YumContentFacet facet = (YumContentFacet)repository.facet(YumContentFacet.class);
        return facet.assets().path(this.buildRepomdPath(path)).find();
    }

    private String buildRepomdPath(String path) {
        String repomdPath = path;
        if (StringUtils.isEmpty((CharSequence)path)) {
            repomdPath = "repodata/repomd.xml";
        }
        if (!path.endsWith("repodata/repomd.xml")) {
            repomdPath = String.valueOf(path) + "repodata/repomd.xml";
        }
        return StringUtils.prependIfMissing((String)repomdPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }
}

