/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal.data;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.content.kv.KeyValue;
import org.sonatype.nexus.repository.content.kv.KeyValueFacetSupport;
import org.sonatype.nexus.repository.yum.datastore.data.YumKeyValueDAO;
import org.sonatype.nexus.repository.yum.datastore.internal.data.YumKeyValueStore;

@Named(value="yum")
@Facet.Exposed
public class YumKeyValueFacet
extends KeyValueFacetSupport<YumKeyValueDAO, YumKeyValueStore> {
    private final int limit;

    @Inject
    public YumKeyValueFacet(@Named(value="${nexus.yum.paging.size:-100}") @Named(value="${nexus.yum.paging.size:-100}") int limit) {
        super("yum", YumKeyValueDAO.class);
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0);
        this.limit = limit;
    }

    public void addRpm(String repoLocation, int componentId, int assetId, String yumRpmJson) {
        this.set(repoLocation, this.rpmKey(componentId, assetId), yumRpmJson);
    }

    public List<String> browseRepoLocations() {
        return this.browseCategories();
    }

    public Stream<String> browseRpms(String repoLocation) {
        return Continuations.streamOf((limit, continuationToken) -> this.browseValues(repoLocation, (int)limit, (String)continuationToken), (int)this.limit).map(KeyValue::getValue);
    }

    public Stream<KeyValue> browseRpmsInfo(String repoLocation) {
        return Continuations.streamOf((limit, continuationToken) -> this.browseValues(repoLocation, (int)limit, (String)continuationToken), (int)this.limit);
    }

    public boolean isRpmRegistered(String repoLocation, int componentId, int assetId) {
        String rpmKey = this.rpmKey(componentId, assetId);
        return Continuations.streamOf((limit, continuationToken) -> this.browseValues(repoLocation, (int)limit, (String)continuationToken), (int)this.limit).map(KeyValue::getKey).anyMatch(s -> s.equalsIgnoreCase(rpmKey));
    }

    public int countRpms(String repoLocation) {
        return this.countValues(repoLocation);
    }

    public void expireRpmCache() {
        this.browseCategories().forEach(arg_0 -> ((YumKeyValueFacet)this).removeAll(arg_0));
    }

    public void removeYumRpm(String repoLocation, int componentId, int assetId) {
        this.remove(repoLocation, this.rpmKey(componentId, assetId));
    }

    public void removeYumRpm(KeyValue keyValue) {
        this.remove(keyValue.getCategory(), keyValue.getKey());
    }

    public List<KeyValue> findRepoLocation(int componentId) {
        return ((YumKeyValueStore)this.dataStore).findKeyStartsWith(this.repositoryId(), this.rpmKeyPrefix(componentId));
    }

    private String rpmKey(int componentId, int assetId) {
        return "rpm-" + componentId + '-' + assetId;
    }

    private String rpmKeyPrefix(int componentId) {
        return "rpm-" + componentId + '-';
    }
}

