/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal.createrepo;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.MultipleFailures;
import org.sonatype.nexus.common.function.ThrowingSupplier;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.PathPayload;
import org.sonatype.nexus.repository.yum.internal.createrepo.FileListMetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.MetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.OtherMetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.PrimaryMetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.RepomdMetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataFile;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadataType;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpm;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;

class YumMetadataRebuilder
extends ComponentSupport
implements AutoCloseable {
    private static final String GZIP = "application/x-gzip";
    private final MultipleFailures failures = new MultipleFailures();
    private boolean closed = false;
    private List<MetadataWriter<YumRpm>> writers = new ArrayList<MetadataWriter<YumRpm>>();
    private final String repoLocation;
    private Path comps;
    private Path fileListPath;
    private Path other;
    private Path primary;
    private Path repomd;

    YumMetadataRebuilder(String repoLocation) {
        this.repoLocation = (String)Preconditions.checkNotNull((Object)repoLocation);
    }

    void start(int rpmCount) {
        try {
            this.fileListPath = Files.createTempFile("filelist", YumMetadataType.FILELISTS.getFileType(), new FileAttribute[0]);
            this.writers.add(new FileListMetadataWriter(YumMetadataRebuilder.gzipOutputStream(this.fileListPath)));
            this.other = Files.createTempFile("other", YumMetadataType.OTHER.getFileType(), new FileAttribute[0]);
            this.writers.add(new OtherMetadataWriter(YumMetadataRebuilder.gzipOutputStream(this.other)));
            this.primary = Files.createTempFile("primary", YumMetadataType.PRIMARY.getFileType(), new FileAttribute[0]);
            this.writers.add(new PrimaryMetadataWriter(YumMetadataRebuilder.gzipOutputStream(this.primary)));
            this.writeToAll(writer -> writer.start(rpmCount));
        }
        catch (IOException | XMLStreamException exception) {
            this.close();
            this.deleteQuietly(this.fileListPath);
            this.deleteQuietly(this.other);
            this.deleteQuietly(this.primary);
        }
    }

    /*
     * Loose catch block
     */
    Payload createRepoMd(String repoLocation, OffsetDateTime rebuildStart, Optional<ThrowingSupplier<YumMetadata>> compsStreamSupplier) throws IOException {
        this.repomd = Files.createTempFile("repomd", YumMetadataType.REPOMD.getFileType(), new FileAttribute[0]);
        int startTimeInSeconds = (int)rebuildStart.toEpochSecond();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                PathPayload pathPayload;
                RepomdMetadataWriter repomdMetadataWriter;
                BufferedOutputStream out;
                block24: {
                    block23: {
                        out = new BufferedOutputStream(Files.newOutputStream(this.repomd, StandardOpenOption.CREATE));
                        repomdMetadataWriter = new RepomdMetadataWriter(out, startTimeInSeconds);
                        repomdMetadataWriter.startMetadata(0);
                        repomdMetadataWriter.append(YumMetadataUtils.readCompressedMetadata(new YumMetadataFile(YumMetadataType.FILELISTS, this.fileListPath)));
                        repomdMetadataWriter.append(YumMetadataUtils.readCompressedMetadata(new YumMetadataFile(YumMetadataType.OTHER, this.other)));
                        repomdMetadataWriter.append(YumMetadataUtils.readCompressedMetadata(new YumMetadataFile(YumMetadataType.PRIMARY, this.primary)));
                        if (compsStreamSupplier.isPresent()) {
                            try {
                                YumMetadata comps = (YumMetadata)compsStreamSupplier.get().get();
                                this.writeTo(repomdMetadataWriter, w -> w.append(comps));
                            }
                            catch (Exception e) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.warn("Failed to include comps metadata for {}", (Object)repoLocation, (Object)e);
                                }
                                this.log.warn("Failed to include comps metadata for {}", (Object)repoLocation);
                            }
                        }
                        repomdMetadataWriter.end();
                        repomdMetadataWriter.close();
                        pathPayload = new PathPayload(this.repomd, "application/xml");
                        if (repomdMetadataWriter == null) break block23;
                        repomdMetadataWriter.close();
                    }
                    if (out == null) break block24;
                    ((OutputStream)out).close();
                }
                return pathPayload;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (repomdMetadataWriter != null) {
                                repomdMetadataWriter.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (out != null) {
                                ((OutputStream)out).close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (XMLStreamException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error("Failed to create repomd.xml", (Throwable)e);
            } else {
                this.log.error("Failed to create repomd.xml cause: {}", (Object)e.getMessage());
            }
            throw new RuntimeException(e);
        }
    }

    void maybePropagate() throws MultipleFailures.MultipleFailuresException {
        this.failures.maybePropagate("Errors occurred during rebuilding");
    }

    void add(YumRpm rpm) {
        this.log.debug("Adding RPM {}", (Object)rpm.getLocation());
        if (rpm.getLocation().startsWith(this.repoLocation)) {
            rpm.setLocation(rpm.getLocation().substring(this.repoLocation.length()));
        }
        this.writeToAll(writer -> writer.append(rpm));
    }

    Payload getFileList() {
        this.checkClosed();
        return new PathPayload(this.fileListPath, GZIP);
    }

    Payload getOther() {
        this.checkClosed();
        return new PathPayload(this.other, GZIP);
    }

    Payload getPrimary() {
        this.checkClosed();
        return new PathPayload(this.primary, GZIP);
    }

    @Override
    public void close() {
        try {
            this.writeToAll(MetadataWriter::end);
        }
        finally {
            this.writeToAll(MetadataWriter::close);
            this.closed = true;
        }
    }

    void delete() {
        this.deleteQuietly(this.fileListPath);
        this.deleteQuietly(this.other);
        this.deleteQuietly(this.primary);
        this.deleteQuietly(this.repomd);
        this.deleteQuietly(this.comps);
    }

    private YumMetadata readComps(InputStreamSupplier inputSupplier) {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream in = inputSupplier.get();){
                this.comps = Files.createTempFile("comps", YumMetadataType.COMPS.getFileType(), new FileAttribute[0]);
                YumMetadata compsMetadata = YumMetadataUtils.readCompressedMetadata(new YumMetadataFile(YumMetadataType.COMPS_GZ, this.comps), in);
                return compsMetadata;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.debug("Failed to read comps file", (Throwable)e);
            this.failures.add((Throwable)e);
            return null;
        }
    }

    private void checkClosed() {
        Preconditions.checkState((boolean)this.closed, (Object)"The YumMetadataRebuilder was not closed before retrieving payload");
    }

    private void writeToAll(ExceptionalConsumer<MetadataWriter<YumRpm>> method) {
        for (MetadataWriter<YumRpm> writer : this.writers) {
            this.writeTo(writer, method);
        }
    }

    private <W extends MetadataWriter<?>> void writeTo(W writer, ExceptionalConsumer<W> method) {
        try {
            method.accept(writer);
        }
        catch (XMLStreamException e) {
            this.log.debug("Failed action on {}", writer, (Object)e);
            this.failures.add((Throwable)e);
        }
    }

    private void deleteQuietly(Path path) {
        if (path == null) {
            return;
        }
        try {
            Files.deleteIfExists(path);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.info("Failed to delete {}", (Object)path, (Object)e);
            }
            this.log.info("Failed to delete {} : {}", (Object)path, (Object)e.getMessage());
        }
    }

    private static OutputStream gzipOutputStream(Path path) throws IOException {
        return new GzipCompressorOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0])));
    }

    @FunctionalInterface
    private static interface ExceptionalConsumer<T> {
        public void accept(T var1) throws XMLStreamException;
    }
}

