/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal.createrepo;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.Optional;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.yum.datastore.internal.createrepo.YumMetadataSupportFacet;
import org.sonatype.nexus.scheduling.ExternalTaskState;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Once;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@Named
@Facet.Exposed
public class YumHostedMetadataRebuildFacet
extends YumMetadataSupportFacet
implements EventAware.Asynchronous {
    private final TaskScheduler taskScheduler;
    private final Cooperation2Factory.Builder cooperationBuilder;
    private Cooperation2 cooperation;
    private final Duration rebuildDelay;

    @Inject
    public YumHostedMetadataRebuildFacet(TaskScheduler taskScheduler, Cooperation2Factory cooperationFactory, @Named(value="${nexus.yum.createrepo.interval:-60000}") @Named(value="${nexus.yum.createrepo.interval:-60000}") long rebuildDelay, @Named(value="${nexus.yum.metadata.cooperation.enabled:-true}") @Named(value="${nexus.yum.metadata.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.yum.metadata.cooperation.majorTimeout:-0s}") @Named(value="${nexus.yum.metadata.cooperation.majorTimeout:-0s}") Duration majorTimeout, @Named(value="${nexus.yum.metadata.cooperation.minorTimeout:-30s}") @Named(value="${nexus.yum.metadata.cooperation.minorTimeout:-30s}") Duration minorTimeout, @Named(value="${nexus.yum.metadata.cooperation.threadsPerKey:-100}") @Named(value="${nexus.yum.metadata.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        Preconditions.checkArgument((rebuildDelay >= 0L ? 1 : 0) != 0, (Object)"nexus.yum.createrepo.interval must be positive");
        this.rebuildDelay = Duration.ofMillis(rebuildDelay);
        this.cooperationBuilder = ((Cooperation2Factory)Preconditions.checkNotNull((Object)cooperationFactory)).configure().majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey).enabled(cooperationEnabled);
    }

    protected void doStart() {
        this.cooperation = this.cooperationBuilder.build(((Object)((Object)this)).getClass(), new String[]{this.getRepository().getName()});
    }

    public void maybeScheduleRebuild(String basePath) {
        this.log.debug("Maybe scheduling rebuild for {} path {}", (Object)this.getRepository().getName(), (Object)basePath);
        try {
            TaskInfo taskInfo = (TaskInfo)this.cooperation.on(() -> this.scheduleBuild(basePath)).checkFunction(() -> this.getScheduledTask(basePath)).performWorkOnFail(false).cooperate(basePath, new String[0]);
            this.log.debug("Found or scheduled task {}", (Object)taskInfo);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.warn("Failed to schedule rebuild of metadata for repository {}", (Object)this.getRepository().getName(), (Object)e);
            }
            this.log.warn("Failed to schedule rebuild of metadata for repository {} cause: {}", (Object)this.getRepository().getName(), (Object)e.getMessage());
        }
    }

    private TaskInfo scheduleBuild(String path) {
        this.log.debug("Attempting to schedule task for {}:{}", (Object)this.getRepository().getName(), (Object)path);
        return this.getScheduledTask(path).orElseGet(() -> {
            this.log.debug("Scheduling new task for repository {}", (Object)this.getRepository().getName());
            TaskConfiguration taskConfiguration = this.taskScheduler.createTaskConfigurationInstance("automatic.yum.metadata.rebuild");
            taskConfiguration.setName("Metadata rebuild for " + this.getRepository().getName() + " for " + path);
            taskConfiguration.setString("basePath", path);
            taskConfiguration.setString("repositoryName", this.getRepository().getName());
            long time = OffsetDateTime.now().plus(this.rebuildDelay).toInstant().toEpochMilli();
            return this.taskScheduler.scheduleTask(taskConfiguration, (Schedule)new Once(new Date(time)));
        });
    }

    private Optional<TaskInfo> getScheduledTask(String path) {
        return this.taskScheduler.listsTasks().stream().filter(task -> "automatic.yum.metadata.rebuild".equals(task.getTypeId())).peek(task -> this.log.trace("Matching type: {}", task)).filter(this::isForSameRepository).peek(task -> this.log.trace("Matching repository: {}", task)).filter(this.isForSamePath(path)).peek(task -> this.log.trace("Matching path: {}", task)).filter(this::isTaskNotDone).peek(task -> this.log.trace("Found existing task: {}", task)).findAny();
    }

    private boolean isForSameRepository(TaskInfo task) {
        return this.getRepository().getName().equals(task.getConfiguration().getString("repositoryName"));
    }

    private Predicate<TaskInfo> isForSamePath(String basePath) {
        return task -> basePath.equals(task.getConfiguration().getString("basePath"));
    }

    private boolean isTaskNotDone(TaskInfo task) {
        ExternalTaskState externalTaskState = this.taskScheduler.toExternalTaskState(task);
        this.log.debug("Found state {} for task {}", (Object)externalTaskState, (Object)task);
        return !externalTaskState.getState().isDone();
    }
}

