/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal.createrepo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.function.ThrowingSupplier;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.event.asset.AssetDeletedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentPurgedEvent;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAttributes;
import org.sonatype.nexus.repository.content.kv.KeyValue;
import org.sonatype.nexus.repository.content.store.ContentStoreEvent;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.datastore.YumContentFacet;
import org.sonatype.nexus.repository.yum.datastore.internal.YumQueryComponent;
import org.sonatype.nexus.repository.yum.datastore.internal.createrepo.YumHostedMetadataRebuildFacet;
import org.sonatype.nexus.repository.yum.datastore.internal.createrepo.YumMetadataRebuilder;
import org.sonatype.nexus.repository.yum.datastore.internal.createrepo.YumMetadataSupportFacet;
import org.sonatype.nexus.repository.yum.datastore.internal.data.YumKeyValueFacet;
import org.sonatype.nexus.repository.yum.internal.createrepo.CreateRepoFacet;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataFile;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadataType;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpm;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmParser;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@Named
@Facet.Exposed
public class YumHostedMetadataFacet
extends YumMetadataSupportFacet
implements CreateRepoFacet,
EventAware.Asynchronous {
    private static final String DIRTY_TIME_KEY = "dirty_event_time";
    private static final String REPOMD_PATH = "repodata/repomd.xml";
    private final ObjectReader reader;
    private final ObjectWriter writer;
    private final PeriodicJobService periodicJobService;
    private final YumRpmParser yumRpmParser;
    private final YumQueryComponent yumQueryComponent;
    private final Clock clock;
    private final Cooperation2Factory.Builder cooperationBuilder;
    private final Duration cleanupInterval;
    private Cooperation2 cooperation;

    @Inject
    public YumHostedMetadataFacet(ObjectMapper mapper, PeriodicJobService periodicJobService, Clock clock, Cooperation2Factory cooperationFactory, YumRpmParser yumRpmParser, YumQueryComponent yumQueryComponent, @Named(value="${nexus.yum.createrepo.cleanUpInterval:-30000}") @Named(value="${nexus.yum.createrepo.cleanUpInterval:-30000}") long cleanUpInterval, @Named(value="${nexus.yum.metadata.cooperation.enabled:-true}") @Named(value="${nexus.yum.metadata.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.yum.metadata.cooperation.majorTimeout:-0s}") @Named(value="${nexus.yum.metadata.cooperation.majorTimeout:-0s}") Duration majorTimeout, @Named(value="${nexus.yum.metadata.cooperation.minorTimeout:-30s}") @Named(value="${nexus.yum.metadata.cooperation.minorTimeout:-30s}") Duration minorTimeout, @Named(value="${nexus.yum.metadata.cooperation.threadsPerKey:-100}") @Named(value="${nexus.yum.metadata.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        this.reader = ((ObjectMapper)Preconditions.checkNotNull((Object)mapper)).readerFor(YumRpm.class);
        this.writer = mapper.writerFor(YumRpm.class);
        this.periodicJobService = (PeriodicJobService)Preconditions.checkNotNull((Object)periodicJobService);
        this.yumRpmParser = (YumRpmParser)((Object)Preconditions.checkNotNull((Object)((Object)yumRpmParser)));
        this.yumQueryComponent = (YumQueryComponent)Preconditions.checkNotNull((Object)yumQueryComponent);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        Preconditions.checkArgument((cleanUpInterval >= 0L ? 1 : 0) != 0, (Object)"nexus.yum.createrepo.cleanUpInterval must be positive");
        this.cleanupInterval = Duration.ofMillis(cleanUpInterval);
        this.cooperationBuilder = ((Cooperation2Factory)Preconditions.checkNotNull((Object)cooperationFactory)).configure().enabled(cooperationEnabled).majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.cooperation = this.cooperationBuilder.build(String.valueOf(this.getRepository().getName()) + ":repomd");
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetDeletedEvent event) {
        if (!this.isEventApplicable((ContentStoreEvent)event)) {
            return;
        }
        Asset asset = event.getAsset();
        String assetKind = asset.kind();
        if (AssetKind.RPM.name().equals(assetKind)) {
            this.expireRpmMetadata(asset);
        } else if (AssetKind.COMPS.name().equals(assetKind)) {
            String repoLocation = this.nestedRepoLocation(asset.path());
            this.markForRebuild(repoLocation);
        }
    }

    private void expireRpmMetadata(Asset asset) {
        YumHostedMetadataFacet.componentId(asset).ifPresent(componentId -> {
            this.log.debug("Removing metadata for repository: {} asset: {}", (Object)this.getRepository().getName(), (Object)asset.path());
            String repoLocation = this.nestedRepoLocation(asset.path());
            this.data().removeYumRpm(repoLocation, componentId, InternalIds.internalAssetId((Asset)asset));
            this.markForRebuild(repoLocation);
        });
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(ComponentPurgedEvent event) {
        if (!this.isEventApplicable((ContentStoreEvent)event)) {
            return;
        }
        this.log.debug("Components purged {} {}", (Object)this.getRepository().getName(), (Object)event.getComponentIds());
        HashSet modifiedRepoLocations = new HashSet();
        Arrays.stream(event.getComponentIds()).mapToObj(componentId -> this.data().findRepoLocation(componentId)).flatMap(Collection::stream).forEach(keyValue -> {
            modifiedRepoLocations.add(keyValue.getCategory());
            this.data().removeYumRpm((KeyValue)keyValue);
        });
        modifiedRepoLocations.forEach(this::markForRebuild);
    }

    @Guarded(by={"STARTED"})
    public void addRpmMetadata(Asset asset, YumRpm rpm) {
        Preconditions.checkNotNull((Object)asset);
        Preconditions.checkNotNull((Object)rpm);
        this.log.debug("Storing metadata for repository: {} asset: {}", (Object)this.getRepository().getName(), (Object)asset.path());
        String repoLocation = this.nestedRepoLocation(asset.path());
        YumHostedMetadataFacet.componentId(asset).ifPresent(componentId -> {
            this.data().addRpm(repoLocation, componentId, InternalIds.internalAssetId((Asset)asset), this.serialize(rpm));
            this.markForRebuild(repoLocation);
        });
    }

    @Guarded(by={"STARTED"})
    public void addComps(Asset asset) {
        Preconditions.checkNotNull((Object)asset);
        this.log.debug("Adding comps for repository: {} asset: {}", (Object)this.getRepository().getName(), (Object)asset.path());
        this.markForRebuild(this.nestedRepoLocation(asset.path()));
    }

    @Guarded(by={"STARTED"})
    public void maybeRecomputeMetadata(String repoMdLocation) throws IOException {
        this.log.debug("Retrieving metadata {}:{}", (Object)this.getRepository().getName(), (Object)repoMdLocation);
        Preconditions.checkNotNull((Object)repoMdLocation);
        String repoLocation = this.nestedRepoLocation(repoMdLocation);
        if (!this.getCachedRepoMd(repoLocation).isPresent()) {
            this.rebuildMetadata(repoLocation);
        }
    }

    private boolean metadataExists(Asset asset) {
        int assetId = InternalIds.internalAssetId((Asset)asset);
        String repoLocation = this.nestedRepoLocation(asset.path());
        return YumHostedMetadataFacet.componentId(asset).isPresent() && this.data().isRpmRegistered(repoLocation, YumHostedMetadataFacet.componentId(asset).getAsInt(), assetId);
    }

    @Override
    public void invalidateMetadataWithoutWaiting(boolean useCache) {
        if (!useCache) {
            this.log.debug("Expiring existing metadata {}", (Object)this.getRepository().getName());
            this.data().expireRpmCache();
            this.migrateRpmsToDatastore();
        }
        String repositoryName = this.getRepository().getName();
        for (String repoLocation : this.data().browseRepoLocations()) {
            try {
                this.cleanMissedRpms(repoLocation);
                this.log.debug("Rebuilding metadata {}:{}", (Object)this.getRepository().getName(), (Object)repoLocation);
                this.rebuildMetadata(repoLocation);
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    this.log.error("Failed to rebuild metadata {} : {}", new Object[]{repositoryName, repoLocation, e});
                    continue;
                }
                this.log.error("Failed to rebuild metadata {} : {} - {}", new Object[]{repositoryName, repoLocation, e.getMessage()});
            }
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void invalidateMetadataWithoutWaiting(boolean useCache, List<String> movedComponentIds) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Guarded(by={"STARTED"})
    public void migrateRpmsToDatastore() {
        Repository repository = this.getRepository();
        this.log.debug("Start RPMs migration for repository {}", (Object)repository.getName());
        Iterable<FluentAsset> rpms = this.yumQueryComponent.browseRpmsForPath(repository, null);
        rpms.forEach(rpm -> rpm.blob().ifPresent(assetBlob -> this.tryToAddRpmMetadata((FluentAsset)rpm)));
    }

    private void tryToAddRpmMetadata(FluentAsset asset) {
        CancelableHelper.checkCancellation();
        if (this.metadataExists((Asset)asset)) {
            this.log.debug("Yum metadata record already registered in the DB {}", (Object)asset.path());
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = asset.download().openInputStream();){
                YumRpm yumRpm = this.yumRpmParser.parse(inputStream, asset.path());
                this.addRpmMetadata((Asset)asset, yumRpm);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error("Error parsing RPM {}", (Object)asset.path(), (Object)e);
            }
            this.log.error("Error parsing RPM {}, error {}", (Object)asset.path(), (Object)e.getMessage());
        }
    }

    @Guarded(by={"STARTED"})
    public boolean needsRebuild(String repoMdLocation) {
        String repoLocation = this.nestedRepoLocation(repoMdLocation);
        Optional<Content> content = this.content().getRepomdForRepoLocation(repoLocation);
        if (!content.isPresent()) {
            this.log.debug("repomd.xml does not exist for {} in {}", (Object)repoMdLocation, (Object)this.getRepository().getName());
            return this.data().countRpms(repoLocation) > 0 || this.content().findComps(repoLocation).isPresent();
        }
        Asset asset = (Asset)content.get().getAttributes().get(Asset.class);
        if (this.isMarkedForRebuild(asset)) {
            return true;
        }
        NestedAttributesMap yumAttr = asset.attributes("yum");
        this.log.debug("Examining attributes {} for {} in {}", new Object[]{yumAttr, repoMdLocation, this.getRepository().getName()});
        if (!((Boolean)yumAttr.get("has_comps", Boolean.class, (Object)false)).equals(this.content().findComps(repoLocation).isPresent())) {
            return true;
        }
        return this.data().countRpms(repoLocation) != ((Integer)yumAttr.get("rpm_count", Integer.class, (Object)0)).intValue();
    }

    private Optional<Content> getCachedRepoMd(String repoLocation) {
        return this.content().getRepomdForRepoLocation(repoLocation).filter(content -> !this.needsRebuild(((Asset)content.getAttributes().get(Asset.class)).path()));
    }

    private void cleanMissedRpms(String repoLocation) {
        this.log.debug("Start cleaning metadata datastore entries for missed RPMs for repoLocation {}", (Object)repoLocation);
        int count = this.data().countRpms(repoLocation);
        if (count == 0) {
            this.log.debug("No RPMs found");
            return;
        }
        this.data().browseRpmsInfo(repoLocation).filter(Objects::nonNull).filter(__ -> CancelableHelper.checkCancellation()).forEach(this::tryToCleanMetadataInfoForRpm);
    }

    private void tryToCleanMetadataInfoForRpm(KeyValue info) {
        YumRpm yumRpm = this.deserialize(info.getValue());
        this.log.debug("Trying to remove RPM {} metadata if this file does not exist in repository", (Object)yumRpm.getLocation());
        boolean rpmFoundInRepository = this.content().get(yumRpm.getLocation()).isPresent();
        if (rpmFoundInRepository) {
            this.log.debug("Asset {} found in the repository. Skip it.", (Object)yumRpm.getLocation());
            return;
        }
        this.data().removeYumRpm(info);
    }

    private Optional<Content> rebuildMetadata(String repoLocation) throws IOException {
        Content result = (Content)this.cooperation.on(() -> this.doRebuildMetadata(repoLocation)).checkFunction(() -> this.getCachedRepoMd(repoLocation)).cooperate(repoLocation, new String[0]);
        return Optional.ofNullable(result);
    }

    @Nullable
    private Content doRebuildMetadata(String repoLocation) throws IOException {
        this.log.debug("Starting rebuilding metadata at {} : {}", (Object)this.getRepository().getName(), (Object)repoLocation);
        OffsetDateTime rebuildStart = this.clock.clusterTime();
        YumMetadataRebuilder builder = new YumMetadataRebuilder(repoLocation);
        try {
            int count = this.data().countRpms(repoLocation);
            Optional<ThrowingSupplier<YumMetadata>> compsSupplier = this.content().findComps(repoLocation).map(this::toCompsMetadataSupplier);
            if (count == 0 && !compsSupplier.isPresent()) {
                this.log.debug("No RPMs found removing abandoned files", (Object)this.getRepository().getName(), (Object)repoLocation);
                this.content().deleteRepomd(repoLocation);
                this.scheduleRemoveDeadMetadata(repoLocation, 0);
                return null;
            }
            builder.start(count);
            this.data().browseRpms(repoLocation).map(this::deserialize).filter(Objects::nonNull).filter(__ -> CancelableHelper.checkCancellation()).forEach(builder::add);
            builder.close();
            if (this.log.isDebugEnabled()) {
                long finishTime = System.currentTimeMillis();
                this.log.debug("Completed metadata rebuild in {}", (Object)(finishTime - rebuildStart.toInstant().toEpochMilli()));
            }
            this.scheduleRemoveDeadMetadata(repoLocation, 1);
            Content content = this.writeMetadata(repoLocation, rebuildStart, builder, compsSupplier, count, compsSupplier.isPresent());
            return content;
        }
        finally {
            builder.close();
            builder.delete();
        }
    }

    private Content writeMetadata(String repoLocation, OffsetDateTime rebuildStart, YumMetadataRebuilder rebuilder, Optional<ThrowingSupplier<YumMetadata>> compsSupplier, int rpmCount, boolean hasComps) throws IOException {
        this.content().putFileList(repoLocation, rebuilder.getFileList());
        this.content().putOther(repoLocation, rebuilder.getOther());
        this.content().putPrimary(repoLocation, rebuilder.getPrimary());
        Payload repomdPayload = rebuilder.createRepoMd(repoLocation, rebuildStart, compsSupplier);
        Content repomd = this.content().putRepomd(repoLocation, repomdPayload, rebuildStart, rpmCount, hasComps);
        this.scheduleRemoveDeadMetadata(repoLocation, 1);
        return repomd;
    }

    private void markForRebuild(String repoLocation) {
        if (this.data().countRpms(repoLocation) == 0 && !this.content().findComps(repoLocation).isPresent()) {
            this.log.debug("Removing metadata for {}:{} as no RPM content is stored", (Object)this.getRepository().getName(), (Object)repoLocation);
            this.content().deleteRepomd(repoLocation);
            this.scheduleRemoveDeadMetadata(repoLocation, 0);
        } else {
            this.log.debug("Marking metadata for {}:{} to rebuild", (Object)this.getRepository().getName(), (Object)repoLocation);
            this.content().assets().path(String.valueOf(repoLocation) + REPOMD_PATH).find().ifPresent(asset -> {
                FluentAttributes fluentAttributes = asset.attributes(AttributeOperation.OVERLAY, "yum", Collections.singletonMap(DIRTY_TIME_KEY, this.clock.clusterTime().toString()));
            });
            ((YumHostedMetadataRebuildFacet)this.getRepository().facet(YumHostedMetadataRebuildFacet.class)).maybeScheduleRebuild(repoLocation);
        }
    }

    private boolean isMarkedForRebuild(Asset asset) {
        NestedAttributesMap yumAttributes = asset.attributes().child("yum");
        String dirtyTimeStr = (String)yumAttributes.get(DIRTY_TIME_KEY, String.class);
        if (dirtyTimeStr == null) {
            this.log.debug("Metadata {}:{} not marked as dirty", (Object)this.getRepository().getName(), (Object)asset.path());
            return false;
        }
        String rebuildTimeStr = (String)yumAttributes.get("rebuilt_time", String.class);
        if (rebuildTimeStr == null) {
            this.log.debug("Metadata {}:{} has no rebuilt timestamp", (Object)this.getRepository().getName(), (Object)asset.path());
            return true;
        }
        this.log.debug("Metadata has rebuild time {} and dirty time {}", (Object)rebuildTimeStr, (Object)dirtyTimeStr);
        OffsetDateTime dirtyTime = OffsetDateTime.parse(dirtyTimeStr);
        OffsetDateTime rebuildTime = OffsetDateTime.parse(rebuildTimeStr);
        return dirtyTime.isAfter(rebuildTime);
    }

    private String serialize(YumRpm rpm) {
        try {
            return this.writer.writeValueAsString((Object)rpm);
        }
        catch (JsonProcessingException e) {
            this.log.debug("An error occurred serializing RPM metadata: {} {}", new Object[]{rpm.getPkgId(), rpm.getFullVersion(), e});
            throw new RuntimeException("An error occurred serializing RPM metadata", e);
        }
    }

    @Nullable
    private YumRpm deserialize(String yumRpmStr) {
        try {
            return (YumRpm)this.reader.readValue(yumRpmStr, YumRpm.class);
        }
        catch (IOException e) {
            this.log.debug("Failed to deserialize YumRpm from '{}'", (Object)yumRpmStr, (Object)e);
            return null;
        }
    }

    private void scheduleRemoveDeadMetadata(String repoLocation, int keep) {
        this.periodicJobService.runOnce(() -> this.removeDeadMetadata(repoLocation, keep), (int)this.cleanupInterval.getSeconds());
    }

    private void removeDeadMetadata(String repoLocation, int keep) {
        String filter = "path LIKE #{filterParams.pathParam} AND kind = #{filterParams.kindParam}";
        ImmutableMap params = ImmutableMap.of((Object)"kindParam", (Object)((Object)AssetKind.REPODATA), (Object)"pathParam", (Object)(String.valueOf(repoLocation) + "%"));
        Continuation assets = this.content().assets().byFilter(filter, (Map)params).browse(100, null);
        int maintain = keep;
        if (maintain == 0 && this.getCachedRepoMd(repoLocation).isPresent()) {
            maintain = 1;
        }
        this.log.debug("Removing dead metadata {}:{} keeping {}", new Object[]{this.getRepository().getName(), repoLocation, maintain});
        YumHostedMetadataFacet.removeOlderMetadataByType((Collection<FluentAsset>)assets, maintain, YumMetadataType.OTHER);
        YumHostedMetadataFacet.removeOlderMetadataByType((Collection<FluentAsset>)assets, maintain, YumMetadataType.PRIMARY);
        YumHostedMetadataFacet.removeOlderMetadataByType((Collection<FluentAsset>)assets, maintain, YumMetadataType.FILELISTS);
    }

    private static void removeOlderMetadataByType(Collection<FluentAsset> assets, int keep, YumMetadataType metadataType) {
        assets.stream().filter(asset -> asset.path().contains(metadataType.getType())).sorted((a, b) -> -a.created().compareTo(b.created())).skip(keep).forEach(FluentAsset::delete);
    }

    private YumContentFacet content() {
        return (YumContentFacet)this.getRepository().facet(YumContentFacet.class);
    }

    private YumKeyValueFacet data() {
        return (YumKeyValueFacet)this.getRepository().facet(YumKeyValueFacet.class);
    }

    private static OptionalInt componentId(Asset asset) {
        return InternalIds.internalComponentId((Asset)asset);
    }

    @Nullable
    private ThrowingSupplier<YumMetadata> toCompsMetadataSupplier(FluentAsset comp) {
        Content content = comp.download();
        if (content == null) {
            return null;
        }
        return () -> {
            if (comp.path().endsWith("xml.gz")) {
                this.log.debug("Found compressed comps.xml: {}", (Object)comp.path());
                return YumMetadataUtils.readCompressedMetadata(new YumMetadataFile(YumMetadataType.COMPS_GZ, Paths.get(comp.path(), new String[0])), content.openInputStream());
            }
            this.log.debug("Found uncompressed comps.xml: {}", (Object)comp.path());
            String checksum = comp.blob().map(AssetBlob::checksums).map(checksums -> (String)checksums.get(HashAlgorithm.SHA256.name())).orElse(null);
            long size = comp.blob().map(AssetBlob::blobSize).orElse(0L);
            return new YumMetadata(YumMetadataType.COMPS).setChecksum(checksum).setSize(size);
        };
    }
}

