/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal.createrepo;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import javax.inject.Inject;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.yum.datastore.internal.createrepo.YumHostedMetadataFacet;
import org.sonatype.nexus.repository.yum.datastore.internal.createrepo.YumHostedMetadataRebuildFacet;
import org.sonatype.nexus.repository.yum.internal.YumFormat;
import org.sonatype.nexus.scheduling.PeriodicJobService;

public class AutomatedYumMetadataRebuildTask
extends RepositoryTaskSupport {
    private final PeriodicJobService jobService;

    @Inject
    public AutomatedYumMetadataRebuildTask(PeriodicJobService jobService) {
        super(false);
        this.jobService = (PeriodicJobService)Preconditions.checkNotNull((Object)jobService);
    }

    public String getMessage() {
        return "Automated yum metadata rebuild";
    }

    protected void execute(Repository repository) {
        String path = this.getConfiguration().getString("basePath");
        this.log.debug("Starting rebuild in {} for {}", (Object)repository.getName(), (Object)path);
        YumHostedMetadataFacet facet = (YumHostedMetadataFacet)repository.facet(YumHostedMetadataFacet.class);
        try {
            long start = System.currentTimeMillis();
            this.log.debug("Rebuilding repository {} path {}", (Object)repository.getName(), (Object)path);
            facet.maybeRecomputeMetadata(path);
            this.log.debug("Completed rebuild in {} ms", (Object)(System.currentTimeMillis() - start));
            this.scheduleCheck(repository, path);
        }
        catch (IOException e) {
            this.log.warn("Failed to rebuild metadata for repository {} path {}", (Object)repository, (Object)path);
            throw new UncheckedIOException(e);
        }
    }

    private void scheduleCheck(Repository repository, String path) {
        try {
            this.jobService.startUsing();
            this.jobService.runOnce(() -> this.maybeRebuild(repository, path), 1);
        }
        catch (Exception e) {
            this.log.warn("Unable to setup verification: {}", (Object)e.getMessage(), (Object)(this.log.isDebugEnabled() ? e : null));
        }
    }

    private void maybeRebuild(Repository repository, String path) {
        block12: {
            try {
                try {
                    if (((YumHostedMetadataFacet)repository.facet(YumHostedMetadataFacet.class)).needsRebuild(path)) {
                        ((YumHostedMetadataRebuildFacet)repository.facet(YumHostedMetadataRebuildFacet.class)).maybeScheduleRebuild(path);
                    }
                }
                catch (Exception e) {
                    this.log.warn("An error occurred verifying repository rebuild: {}", (Object)e.getMessage(), (Object)(this.log.isDebugEnabled() ? e : null));
                    try {
                        this.jobService.stopUsing();
                    }
                    catch (Exception e2) {
                        this.log.warn("Unable to stop using job service: {}", (Object)e2.getMessage(), (Object)(this.log.isDebugEnabled() ? e2 : null));
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.jobService.stopUsing();
                }
                catch (Exception e) {
                    this.log.warn("Unable to stop using job service: {}", (Object)e.getMessage(), (Object)(this.log.isDebugEnabled() ? e : null));
                }
                throw throwable;
            }
            try {
                this.jobService.stopUsing();
            }
            catch (Exception e) {
                this.log.warn("Unable to stop using job service: {}", (Object)e.getMessage(), (Object)(this.log.isDebugEnabled() ? e : null));
            }
        }
    }

    protected boolean appliesTo(Repository repository) {
        return repository.getType() instanceof HostedType && repository.getFormat() instanceof YumFormat;
    }
}

