/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.facet.ContentProxyFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.utils.FormatAttributesUtils;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Headers;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlobPayload;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.datastore.YumContentFacet;
import org.sonatype.nexus.repository.yum.internal.gpg.YumSigningFacet;
import org.sonatype.nexus.repository.yum.internal.metadata.CompressedTempBlob;
import org.sonatype.nexus.repository.yum.internal.metadata.RepomdProcessor;
import org.sonatype.nexus.repository.yum.internal.metadata.YumAbsoluteUrlRemover;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;
import org.sonatype.nexus.repository.yum.utils.TempBlobConverter;
import org.sonatype.nexus.repository.yum.utils.YumFacetUtils;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;
import org.w3c.dom.Document;

@Named
@Facet.Exposed
public class YumProxyFacet
extends ContentProxyFacetSupport {
    private static final String REPODATA_PATH = "repodata/";
    public static final String RHUI_SIGNATURE_HEADER = "X-RHUI-SIGNATURE";
    public static final String RHUI_ID_HEADER = "X-RHUI-ID";
    private static final ImmutableSet<String> CHARS_TO_ENCODE = ImmutableSet.of((Object)"^");
    private final RepomdProcessor repomdProcessor;
    private final TempBlobConverter tempBlobConverter;
    private final YumAbsoluteUrlRemover yumAbsoluteUrlRemover;

    @Inject
    public YumProxyFacet(RepomdProcessor repomdProcessor, TempBlobConverter tempBlobConverter, YumAbsoluteUrlRemover yumAbsoluteUrlRemover) {
        this.repomdProcessor = (RepomdProcessor)((Object)Preconditions.checkNotNull((Object)((Object)repomdProcessor)));
        this.tempBlobConverter = (TempBlobConverter)Preconditions.checkNotNull((Object)tempBlobConverter);
        this.yumAbsoluteUrlRemover = (YumAbsoluteUrlRemover)((Object)Preconditions.checkNotNull((Object)((Object)yumAbsoluteUrlRemover)));
    }

    protected Content doGet(Context context, Content staleContent) throws IOException {
        YumSigningFacet yumSigningFacet = (YumSigningFacet)this.facet(YumSigningFacet.class);
        Optional<Content> metadataSignature = yumSigningFacet.maybeSignRepoMetadata(context, this.getRepository());
        if (metadataSignature.isPresent()) {
            return metadataSignature.get();
        }
        return super.doGet(context, staleContent);
    }

    @Nullable
    protected Content getCachedContent(Context context) {
        String assetPath = YumPathUtils.buildAssetPath(YumPathUtils.matcherState(context));
        String contentAssetPath = StringUtils.prependIfMissing((String)assetPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return ((YumContentFacet)this.facet(YumContentFacet.class)).get(contentAssetPath).map(FluentAsset::download).orElse(null);
    }

    protected Content store(Context context, Content content) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        TokenMatcher.State matcherState = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String assetPath = YumPathUtils.buildAssetPath(matcherState);
        String contentAssetPath = StringUtils.prependIfMissing((String)assetPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        if (assetKind == AssetKind.RPM) {
            return ((YumContentFacet)this.facet(YumContentFacet.class)).putRPM(contentAssetPath, (Payload)content);
        }
        return this.putMetadata(contentAssetPath, content, assetKind, context);
    }

    protected String getUrl(@NotNull Context context) {
        return context.getRequest().getPath().substring(1);
    }

    protected String encodeUrl(String url) throws UnsupportedEncodingException {
        String encodedUrl = url;
        for (String ch : CHARS_TO_ENCODE) {
            encodedUrl = encodedUrl.replace(ch, URLEncoder.encode(ch, "UTF-8"));
        }
        return encodedUrl;
    }

    protected CacheController getCacheController(Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        return this.cacheControllerHolder.require(assetKind.getCacheType());
    }

    protected HttpResponse execute(Context context, HttpClient client, HttpRequestBase request) throws IOException {
        Headers headers = context.getRequest().getHeaders();
        this.copyHeaderIfPresent(request, headers, RHUI_SIGNATURE_HEADER);
        this.copyHeaderIfPresent(request, headers, RHUI_ID_HEADER);
        return super.execute(context, client, request);
    }

    private void clearRepodataIfRepomdAssetKind(AssetKind assetKind, String assetPath) {
        if (assetKind == AssetKind.REPOMD) {
            Continuations.streamOf(((YumContentFacet)this.facet(YumContentFacet.class)).get(AssetKind.REPODATA)).filter(e -> this.isAssetInSameFolderAsRepomd(assetPath, e.path())).forEach(FluentAsset::delete);
        }
    }

    private boolean isAssetInSameFolderAsRepomd(String assetPath, String assetName) {
        String prefix = assetPath.substring(0, assetPath.indexOf(REPODATA_PATH) + REPODATA_PATH.length());
        return assetName.startsWith(prefix);
    }

    private void copyHeaderIfPresent(HttpRequestBase request, Headers headers, String headerName) {
        if (headers.contains(headerName)) {
            this.log.debug("Adding header {} from Yum client", (Object)headerName);
            request.addHeader(headerName, headers.get(headerName));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Content processPrimary(String assetPath, Content payload, AssetKind assetKind) {
        YumContentFacet content = (YumContentFacet)this.facet(YumContentFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = content.ingest((Payload)payload, YumMetadataUtils.HASH_ALGORITHMS);){
            CompressedTempBlob compressedTempBlob;
            if (!this.yumAbsoluteUrlRemover.containsAbsoluteUrl(tempBlob, assetPath)) return content.put(assetPath, (Payload)new Content(payload, (Payload)new TempBlobPayload(tempBlob, payload.getContentType())), assetKind);
            Throwable throwable2 = null;
            Object var9_12 = null;
            try {
                compressedTempBlob = this.yumAbsoluteUrlRemover.removeAbsoluteUrls(tempBlob, assetPath, this.getRepository());
                try {
                    if (compressedTempBlob.isModified()) {
                        TempBlobPayload metadataPayload = new TempBlobPayload(compressedTempBlob.getTempBlob(), payload.getContentType());
                        Content result = content.put(assetPath, (Payload)new Content(payload, (Payload)metadataPayload), assetKind);
                        FormatAttributesUtils.setFormatAttributes((FluentAsset)content.assets().with((Asset)result.getAttributes().require(Asset.class)), () -> {
                            HashMap<String, Object> attributes = new HashMap<String, Object>();
                            attributes.put("modified", true);
                            attributes.put("open-sha1", compressedTempBlob.getDecompressedHashes().get(HashAlgorithm.SHA1).toString());
                            attributes.put("open-sha256", compressedTempBlob.getDecompressedHashes().get(HashAlgorithm.SHA256).toString());
                            attributes.put("open-sha512", compressedTempBlob.getDecompressedHashes().get(HashAlgorithm.SHA512).toString());
                            attributes.put("open-md5", compressedTempBlob.getDecompressedHashes().get(HashAlgorithm.MD5).toString());
                            attributes.put("open-size", compressedTempBlob.getDecompressedSize());
                            return attributes;
                        });
                        if (compressedTempBlob == null) return result;
                        compressedTempBlob.close();
                        return result;
                    }
                }
                catch (Throwable throwable3) {
                    if (compressedTempBlob == null) throw throwable3;
                    compressedTempBlob.close();
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                    throw throwable2;
                }
                if (throwable2 == throwable4) throw throwable2;
                throwable2.addSuppressed(throwable4);
                throw throwable2;
            }
            if (compressedTempBlob == null) return content.put(assetPath, (Payload)new Content(payload, (Payload)new TempBlobPayload(tempBlob, payload.getContentType())), assetKind);
            compressedTempBlob.close();
            return content.put(assetPath, (Payload)new Content(payload, (Payload)new TempBlobPayload(tempBlob, payload.getContentType())), assetKind);
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    private Content putMetadata(String assetPath, Content content, AssetKind assetKind, Context context) {
        this.clearRepodataIfRepomdAssetKind(assetKind, assetPath);
        if (AssetKind.REPOMD == assetKind) {
            return this.processRepomd(assetPath, content, assetKind, context);
        }
        if (YumFacetUtils.isPrimary(assetPath, assetKind)) {
            return this.processPrimary(assetPath, content, assetKind);
        }
        return ((YumContentFacet)this.facet(YumContentFacet.class)).put(assetPath, (Payload)content, assetKind);
    }

    /*
     * Loose catch block
     */
    private Content processRepomd(String assetPath, Content payload, AssetKind assetKind, Context context) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (TempBlob tempBlob = ((YumContentFacet)this.facet(YumContentFacet.class)).ingest((Payload)payload, YumMetadataUtils.HASH_ALGORITHMS);){
                Content content;
                TempBlob newMetadataContent;
                Throwable throwable2;
                block21: {
                    Document repomdXml = this.tempBlobConverter.toDocument(tempBlob);
                    this.repomdProcessor.process(repomdXml, path -> this.fetchMetadata(path, this.getRepository(), context));
                    String contentType = payload.getContentType();
                    throwable2 = null;
                    Object var11_15 = null;
                    newMetadataContent = this.tempBlobConverter.toTempBlob(repomdXml, this.getRepository());
                    TempBlobPayload newMetadataPayload = new TempBlobPayload(newMetadataContent, contentType);
                    Content content2 = new Content(payload, (Payload)newMetadataPayload);
                    content = ((YumContentFacet)this.facet(YumContentFacet.class)).put(assetPath, (Payload)content2, assetKind);
                    if (newMetadataContent == null) break block21;
                    newMetadataContent.close();
                }
                return content;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (newMetadataContent != null) {
                                newMetadataContent.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private Content fetchMetadata(String path, Repository repository, Context context) {
        String directory = YumPathUtils.extractDirectoryFromMetadataPath(context.getRequest().getPath());
        String requestPath = YumPathUtils.appendPath(directory, path);
        Request mappingRequest = new Request.Builder().action("GET").path(StringUtils.prependIfMissing((String)requestPath, (CharSequence)"/", (CharSequence[])new CharSequence[0])).build();
        try {
            Response response = ((ViewFacet)repository.facet(ViewFacet.class)).dispatch(mappingRequest, context);
            int status = response.getStatus().getCode();
            if (status != 200) {
                this.log.warn("Failed to fetch metadata file for path {} and repository {}. Received status code {}", new Object[]{path, repository.getName(), status});
            }
            return (Content)response.getPayload();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

