/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal;

import com.google.common.hash.HashCode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.utils.FormatAttributesUtils;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.datastore.YumContentFacet;
import org.sonatype.nexus.repository.yum.datastore.internal.YumQueryComponent;
import org.sonatype.nexus.repository.yum.datastore.internal.createrepo.YumHostedMetadataFacet;
import org.sonatype.nexus.repository.yum.internal.YumHostedFacetSupport;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpm;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;

@Named
@Facet.Exposed
public class YumHostedFacet
extends YumHostedFacetSupport {
    private final YumQueryComponent queryComponent;

    @Inject
    public YumHostedFacet(YumQueryComponent queryComponent) {
        this.queryComponent = queryComponent;
    }

    private YumContentFacet content() {
        return (YumContentFacet)this.facet(YumContentFacet.class);
    }

    public Content put(String assetPath, Payload payload, AssetKind assetKind) {
        switch (assetKind) {
            case RPM: {
                this.validateRepodataDepth(assetPath);
                return this.storeRpmMetadata(this.content().putRPM(assetPath, payload));
            }
            case COMPS: {
                return this.storeComps(this.content().put(assetPath, payload, assetKind));
            }
        }
        return this.content().put(assetPath, payload, assetKind);
    }

    public Content putHardLink(String assetPath, Blob blob, Map<HashAlgorithm, HashCode> checksums, AssetKind assetKind) {
        if (assetKind == AssetKind.RPM) {
            this.validateRepodataDepth(assetPath);
            return this.storeRpmMetadata(((YumContentFacet)this.facet(YumContentFacet.class)).putRPMHardLink(assetPath, blob, checksums));
        }
        return ((YumContentFacet)this.facet(YumContentFacet.class)).putHardLink(assetPath, blob, checksums, assetKind);
    }

    public Optional<Content> getRepomd(String repoMdLocation) {
        return this.content().getRepomd(repoMdLocation);
    }

    public List<FluentAsset> getMetadataFilesToDelete(List<String> directories, List<String> excluding) {
        return Continuations.streamOf(((YumContentFacet)this.facet(YumContentFacet.class)).get(AssetKind.REPODATA)).filter(asset -> !excluding.contains(asset.path())).filter(asset -> YumHostedFacet.matchesDirectory(directories, (Asset)asset)).collect(Collectors.toList());
    }

    public void deleteRepomd() {
        this.queryComponent.findRepomd(this.getRepository(), null).ifPresent(FluentAsset::delete);
    }

    public void deleteRepomdIfNoRpmsLeft(@Nullable String directory) {
        long count = this.queryComponent.countRpmsInDirectory(this.getRepository(), directory);
        if (count == 0L) {
            this.queryComponent.findRepomd(this.getRepository(), directory).ifPresent(FluentAsset::delete);
        }
    }

    public void deleteRepodataIfNoRpmsLeft(@Nullable String directory) {
        long count = this.queryComponent.countRpmsInDirectory(this.getRepository(), directory);
        if (count == 0L) {
            this.queryComponent.findRepodataAssetsOnPath(this.getRepository(), directory).forEach(FluentAsset::delete);
        }
    }

    public void setRpmsRemovedFlagIfCountChanged(String folder, long expectedRpmCount) {
        long rpms = this.queryComponent.countRpmsInDirectory(this.getRepository(), folder);
        this.markMetadataAsRpmsRemoved(folder, rpms < expectedRpmCount);
    }

    public void metadataGenerationStarted(long at) {
        ((YumContentFacet)this.facet(YumContentFacet.class)).withAttribute("metadata_generation_time", at);
    }

    public long getMetadataGenerationStartedTime() {
        return (Long)((YumContentFacet)this.facet(YumContentFacet.class)).attributes().get("metadata_generation_time", Long.class, (Object)0L);
    }

    public void markMetadataAsRpmsRemoved(String location, boolean removed) {
        Integer repodataDepth = this.getRepodataDepth();
        String directory = YumPathUtils.extractDirectoryAtDepth(StringUtils.removeStart((String)location, (String)"/"), repodataDepth).orElse("");
        String assetPath = StringUtils.prependIfMissing((String)(String.valueOf(directory) + "/repodata/repomd.xml"), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        ((YumContentFacet)this.facet(YumContentFacet.class)).get(assetPath).ifPresent(fluentAsset -> {
            if (removed) {
                this.log.debug("Setting {} to true for repomd in {}:{}", new Object[]{"rpms_removed", this.getRepository().getName(), directory});
                FormatAttributesUtils.setFormatAttributes((FluentAsset)fluentAsset, (String)"rpms_removed", (Object)true);
            } else {
                this.log.debug("Removing {} from repomd in {}:{}", new Object[]{"rpms_removed", this.getRepository().getName(), directory});
                FormatAttributesUtils.removeFormatAttributes((FluentAsset)fluentAsset, (String)"rpms_removed");
            }
        });
    }

    @Override
    protected int getPathDepth(String path) {
        return super.getPathDepth(StringUtils.removeStart((String)path, (String)"/"));
    }

    public int getComponentDepth(FluentComponent component) {
        FluentAsset asset = (FluentAsset)component.assets().stream().findFirst().orElseThrow(() -> new NullPointerException(String.format("No asset for the component %s %s", component.name(), component.version())));
        String path = asset.path();
        return this.getPathDepth(path);
    }

    public String nestedRepoLocation(String assetPath) {
        Integer repodataDepth = this.getRepodataDepth();
        String path = assetPath.substring(1);
        return String.valueOf('/') + YumPathUtils.extractDirectoryAtDepth(path, repodataDepth).map(repoLocation -> String.valueOf(repoLocation) + '/').orElse("");
    }

    private Content storeRpmMetadata(Content content) {
        YumRpm yumRpm = (YumRpm)content.getAttributes().require(YumRpm.class);
        Asset asset = (Asset)content.getAttributes().require(Asset.class);
        ((YumHostedMetadataFacet)this.getRepository().facet(YumHostedMetadataFacet.class)).addRpmMetadata(asset, yumRpm);
        return content;
    }

    private Content storeComps(Content content) {
        ((YumHostedMetadataFacet)this.getRepository().facet(YumHostedMetadataFacet.class)).addComps((Asset)content.getAttributes().require(Asset.class));
        return content;
    }

    private static boolean matchesDirectory(List<String> directories, Asset asset) {
        return directories.isEmpty() || directories.contains(YumPathUtils.extractDirectoryFromMetadataPath(asset.path()));
    }
}

