/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.director.ContentDirector;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.yum.datastore.YumContentFacet;
import org.sonatype.nexus.repository.yum.datastore.internal.YumHostedFacet;
import org.sonatype.nexus.repository.yum.datastore.internal.createrepo.YumHostedMetadataFacet;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpm;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmParser;

@Named(value="yum")
@Singleton
public class YumContentDirector
extends ComponentSupport
implements ContentDirector {
    private final YumRpmParser rpmParser;

    @Inject
    public YumContentDirector(YumRpmParser rpmParser) {
        this.rpmParser = rpmParser;
    }

    public boolean allowMoveTo(Repository destination) {
        return true;
    }

    public boolean allowMoveFrom(Repository source) {
        return true;
    }

    public Component afterMove(Component component, Repository destination) {
        this.log.debug("afterMove {} : {}", (Object)destination.getName(), (Object)component);
        ((YumContentFacet)destination.facet(YumContentFacet.class)).components().with(component).assets().forEach(asset -> {
            this.log.debug("Storing metadata RPM for {} : {}", (Object)destination.getName(), (Object)asset.path());
            ((YumHostedMetadataFacet)destination.facet(YumHostedMetadataFacet.class)).addRpmMetadata((Asset)asset, this.parse((FluentAsset)asset));
        });
        return component;
    }

    public boolean allowMoveTo(FluentComponent component, Repository destination) {
        int destinationDepth;
        YumHostedFacet hostedFacet = (YumHostedFacet)component.repository().facet(YumHostedFacet.class);
        int componentDepth = hostedFacet.getComponentDepth(component);
        return componentDepth >= (destinationDepth = ((YumHostedFacet)destination.facet(YumHostedFacet.class)).getRepodataDepth().intValue());
    }

    private YumRpm parse(FluentAsset asset) {
        this.log.debug("Parsing RPM path {}", (Object)asset.path());
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = asset.download().openInputStream();){
                return this.rpmParser.parse(inputStream, asset.path());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("An error occurred parsing RPM " + asset.path(), e);
        }
    }
}

