/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.maintenance.ContentMaintenanceFacet;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.DeployPolicy;
import org.sonatype.nexus.repository.yum.datastore.YumContentFacet;
import org.sonatype.nexus.repository.yum.datastore.internal.YumHostedFacet;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;

@Named
@Singleton
public class HostedHandlers {
    public final Handler getRepoMdHandler = this::getRepoMd;
    public final Handler getHandler = this::get;
    public final Handler uploadHandler = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String assetPath = StringUtils.prependIfMissing((String)YumPathUtils.buildAssetPath(state), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        AssetKind assetKind = (AssetKind)((Object)((Object)context.getAttributes().require(AssetKind.class)));
        ((YumHostedFacet)context.getRepository().facet(YumHostedFacet.class)).put(assetPath, context.getRequest().getPayload(), assetKind);
        return HttpResponses.ok();
    };
    public final Handler deleteHandler = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String assetPath = StringUtils.prependIfMissing((String)((String)state.getTokens().get("name")), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        YumContentFacet contentFacet = (YumContentFacet)context.getRepository().facet(YumContentFacet.class);
        Optional<FluentAsset> optionalFluentAsset = contentFacet.get(assetPath);
        if (!optionalFluentAsset.isPresent()) {
            return HttpResponses.notFound();
        }
        FluentAsset fluentAsset = optionalFluentAsset.get();
        if (this.isMetadata(fluentAsset)) {
            return HttpResponses.methodNotAllowed((String)context.getRequest().getAction(), (String[])new String[]{"DELETE"});
        }
        ((ContentMaintenanceFacet)context.getRepository().facet(ContentMaintenanceFacet.class)).deleteAsset((Asset)fluentAsset);
        return HttpResponses.ok();
    };
    public final Handler nonYumHandler = context -> {
        String method;
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String assetPath = StringUtils.prependIfMissing((String)((String)state.getTokens().get("name")), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        switch (method = context.getRequest().getAction()) {
            case "GET": 
            case "HEAD": {
                return ((YumContentFacet)context.getRepository().facet(YumContentFacet.class)).get(assetPath).map(FluentAsset::download).map(HttpResponses::ok).orElseGet(HttpResponses::notFound);
            }
            case "PUT": {
                return this.uploadNonYumFile(assetPath, context, (YumHostedFacet)context.getRepository().facet(YumHostedFacet.class));
            }
        }
        return HttpResponses.methodNotAllowed((String)method, (String[])new String[]{"GET", "HEAD", "PUT"});
    };

    public Response getRepoMd(Context context) throws IOException {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String assetPath = StringUtils.prependIfMissing((String)YumPathUtils.buildAssetPath(state), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return ((YumHostedFacet)context.getRepository().facet(YumHostedFacet.class)).getRepomd(assetPath).map(HttpResponses::ok).orElseGet(HttpResponses::notFound);
    }

    public Response get(Context context) throws IOException {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String assetPath = StringUtils.prependIfMissing((String)YumPathUtils.buildAssetPath(state), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return ((YumContentFacet)context.getRepository().facet(YumContentFacet.class)).get(assetPath).map(FluentAsset::download).map(HttpResponses::ok).orElseGet(HttpResponses::notFound);
    }

    private Response uploadNonYumFile(String name, Context context, YumHostedFacet hosted) {
        if (hosted.getDeployPolicy() == DeployPolicy.STRICT) {
            throw new IllegalOperationException("Invalid path for a Yum repository");
        }
        Preconditions.checkState((name != null ? 1 : 0) != 0, (Object)"Missing token: name");
        hosted.put(name, context.getRequest().getPayload(), AssetKind.NON_YUM);
        return HttpResponses.ok();
    }

    private boolean isMetadata(FluentAsset asset) {
        String assetKind = asset.kind();
        return Objects.equals(AssetKind.REPODATA.name(), assetKind) || Objects.equals(AssetKind.REPOMD.name(), assetKind) || Objects.equals(AssetKind.REPOMD_ASC.name(), assetKind);
    }
}

