/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal;

import java.util.Optional;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.yum.datastore.YumContentFacet;

public class ContentBlobUtils {
    public static AssetBlob getAssetBlob(FluentAsset asset) {
        return (AssetBlob)asset.blob().orElseThrow(() -> new RuntimeException("No Asset blob. Asset path " + asset.path()));
    }

    public static Blob getBlob(FluentAsset asset) {
        AssetBlob assetBlob = ContentBlobUtils.getAssetBlob(asset);
        BlobId blobId = assetBlob.blobRef().getBlobId();
        Blob blob = ((BlobStore)((YumContentFacet)asset.repository().facet(YumContentFacet.class)).stores().blobStoreProvider.get()).get(blobId);
        if (blob == null) {
            throw new RuntimeException("No Blob " + blobId.toString() + " Asset path " + asset.path());
        }
        return blob;
    }

    public static Optional<Blob> getBlobOptional(FluentAsset asset) {
        return asset.blob().map(assetBlob -> assetBlob.blobRef().getBlobId()).flatMap(blobId -> {
            Blob blob = ((BlobStore)((YumContentFacet)fluentAsset.repository().facet(YumContentFacet.class)).stores().blobStoreProvider.get()).get(blobId);
            return Optional.ofNullable(blob);
        });
    }
}

