/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.hash.HashAlgorithmHelper;
import org.sonatype.nexus.repository.InvalidContentException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.utils.HardLinkHelper;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.PathPayload;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.DeployPolicy;
import org.sonatype.nexus.repository.yum.datastore.internal.YumHostedFacet;
import org.sonatype.nexus.repository.yum.internal.YumUploadHandlerSupport;
import org.sonatype.nexus.repository.yum.internal.utils.AssetKindUtils;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named(value="yum")
@Singleton
public class YumUploadHandler
extends YumUploadHandlerSupport {
    private final HardLinkHelper hardLinkHelper;
    private final HashAlgorithmHelper hashAlgorithmHelper;

    @Inject
    public YumUploadHandler(Set<UploadDefinitionExtension> uploadDefinitionExtensions, @Named(value="simple") @Named(value="simple") VariableResolverAdapter variableResolverAdapter, ContentPermissionChecker contentPermissionChecker, HardLinkHelper hardLinkHelper, HashAlgorithmHelper hashAlgorithmHelper) {
        super(uploadDefinitionExtensions, variableResolverAdapter, contentPermissionChecker);
        this.hardLinkHelper = (HardLinkHelper)Preconditions.checkNotNull((Object)hardLinkHelper);
        this.hashAlgorithmHelper = (HashAlgorithmHelper)Preconditions.checkNotNull((Object)hashAlgorithmHelper);
    }

    public UploadResponse handle(Repository repository, ComponentUpload upload) {
        AssetUpload assetUpload = (AssetUpload)upload.getAssetUploads().get(0);
        String assetPath = YumUploadHandler.buildAssetPath(upload);
        String contentAssetPath = StringUtils.prependIfMissing((String)assetPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        this.ensurePermitted(repository.getName(), "yum", contentAssetPath, Collections.emptyMap());
        AssetKind assetKind = this.detectKind(assetUpload);
        this.validateDeployPolicy(assetKind, repository);
        YumHostedFacet hostedFacet = (YumHostedFacet)repository.facet(YumHostedFacet.class);
        Content content = hostedFacet.put(contentAssetPath, (Payload)assetUpload.getPayload(), assetKind);
        return new UploadResponse(Collections.singletonList(content), Collections.singletonList(((Asset)content.getAttributes().get(Asset.class)).path()));
    }

    public boolean supportsExportImport() {
        return true;
    }

    public Content handle(Repository repository, File content, String path) throws IOException {
        return this.handle(new ImportFileConfiguration(repository, content, path, false));
    }

    public Content handle(ImportFileConfiguration configuration) throws IOException {
        Repository repository = configuration.getRepository();
        String assetName = configuration.getAssetName();
        String path = StringUtils.prependIfMissing((String)assetName, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        this.ensurePermitted(repository.getName(), "yum", path, Collections.emptyMap());
        AssetKind assetKind = this.getAssetKindAndValidateUpload(configuration);
        if (configuration.isHardLinkingEnabled()) {
            return this.handleImportHardLink(configuration, assetKind);
        }
        return this.handleImport(configuration, assetKind);
    }

    private Content handleImportHardLink(ImportFileConfiguration configuration, AssetKind assetKind) throws IOException {
        Map checksums = this.hashAlgorithmHelper.calculateChecksums(configuration.getFile(), YumMetadataUtils.HASH_ALGORITHMS);
        HashCode sha1HashCode = (HashCode)checksums.get(HashAlgorithm.SHA1);
        Blob blob = this.hardLinkHelper.ingestHardLink(configuration.getRepository(), configuration.getFile(), sha1HashCode);
        return ((YumHostedFacet)configuration.getRepository().facet(YumHostedFacet.class)).putHardLink(configuration.getAssetName(), blob, checksums, assetKind);
    }

    private Content handleImport(ImportFileConfiguration configuration, AssetKind assetKind) throws IOException {
        Repository repository = configuration.getRepository();
        String assetName = configuration.getAssetName();
        Payload payload = this.toPayload(configuration.getFile());
        return ((YumHostedFacet)repository.facet(YumHostedFacet.class)).put(assetName, payload, assetKind);
    }

    private AssetKind getAssetKindAndValidateUpload(ImportFileConfiguration configuration) {
        AssetKind assetKind = AssetKindUtils.detectKindByName(configuration.getFile().getName());
        YumHostedFacet facet = (YumHostedFacet)configuration.getRepository().facet(YumHostedFacet.class);
        if (AssetKind.RPM == assetKind) {
            YumUploadHandler.validateRepodataDepth(facet, configuration.getAssetName());
        } else {
            assetKind = AssetKindUtils.detectKindByPath(configuration.getAssetName());
            YumUploadHandler.validatePermissiveDeployPolicy(facet);
        }
        return assetKind;
    }

    private Payload toPayload(File file) throws IOException {
        Path filePath = file.toPath();
        return new PathPayload(filePath, Files.probeContentType(filePath));
    }

    private AssetKind detectKind(AssetUpload assetUpload) {
        String fileName = assetUpload.getField("filename");
        return AssetKindUtils.detectKindByName(fileName);
    }

    private void validateDeployPolicy(AssetKind assetKind, Repository repository) {
        DeployPolicy deployPolicy = ((YumHostedFacet)repository.facet(YumHostedFacet.class)).getDeployPolicy();
        if (assetKind != AssetKind.RPM && assetKind != AssetKind.COMPS && deployPolicy == DeployPolicy.STRICT) {
            throw new ValidationErrorsException("Uploading non-rpm files is unsupported in strict repositories.");
        }
    }

    private static void validateRepodataDepth(YumHostedFacet yumHostedFacet, String path) {
        try {
            yumHostedFacet.validateRepodataDepth(path);
        }
        catch (InvalidContentException e) {
            throw new ValidationErrorsException(e.getMessage());
        }
    }

    private static void validatePermissiveDeployPolicy(YumHostedFacet yumHostedFacet) {
        if (yumHostedFacet.getDeployPolicy() == DeployPolicy.STRICT) {
            throw new ValidationErrorsException("Uploading non-rpm files is unsupported in strict repositories.");
        }
    }
}

