/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssetBuilder;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.internal.YumAssetAttributePopulator;
import org.sonatype.nexus.repository.yum.internal.YumComponentAttributePopulator;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadataType;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpm;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmParser;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;

@Named(value="yum")
@Facet.Exposed
public class YumContentFacet
extends ContentFacetSupport {
    private static final String PATH_PREFIX = "/";
    public static final String REBUILT_START_TIME_KEY = "rebuilt_time";
    public static final String HAS_COMPS = "has_comps";
    public static final String RPM_COUNT = "rpm_count";
    private final YumRpmParser rpmParser;
    private final YumComponentAttributePopulator componentAttributePopulator;
    private final YumAssetAttributePopulator assetAttributePopulator;

    @Inject
    public YumContentFacet(@Named(value="yum") @Named(value="yum") FormatStoreManager formatStoreManager, YumRpmParser rpmParser, YumComponentAttributePopulator componentAttributePopulator, YumAssetAttributePopulator assetAttributePopulator) {
        super(formatStoreManager);
        this.rpmParser = rpmParser;
        this.componentAttributePopulator = componentAttributePopulator;
        this.assetAttributePopulator = assetAttributePopulator;
    }

    public Optional<Content> getRepomdForRepoLocation(String repoLocation) {
        Preconditions.checkNotNull((Object)repoLocation);
        Preconditions.checkArgument((repoLocation.startsWith(PATH_PREFIX) && repoLocation.endsWith(PATH_PREFIX) ? 1 : 0) != 0, (Object)repoLocation);
        String assetPath = String.valueOf(repoLocation) + "repodata/repomd.xml";
        return this.get(assetPath).map(FluentAsset::download);
    }

    public Optional<Content> getRepomd(String assetPath) {
        Preconditions.checkNotNull((Object)assetPath);
        Preconditions.checkArgument((assetPath.startsWith(PATH_PREFIX) && assetPath.endsWith("repodata/repomd.xml") ? 1 : 0) != 0, (Object)assetPath);
        return this.get(assetPath).map(FluentAsset::download);
    }

    public void deleteRepomd(String repoLocation) {
        Preconditions.checkNotNull((Object)repoLocation);
        Preconditions.checkArgument((repoLocation.startsWith(PATH_PREFIX) && repoLocation.endsWith(PATH_PREFIX) ? 1 : 0) != 0);
        String assetPath = String.valueOf(repoLocation) + "repodata/repomd.xml";
        this.get(assetPath).ifPresent(FluentAsset::delete);
    }

    public Content putFileList(String repoLocation, Payload payload) {
        return this.putMetadata(repoLocation, payload, YumMetadataType.FILELISTS);
    }

    public Content putOther(String repoLocation, Payload payload) {
        return this.putMetadata(repoLocation, payload, YumMetadataType.OTHER);
    }

    public Content putPrimary(String repoLocation, Payload payload) {
        return this.putMetadata(repoLocation, payload, YumMetadataType.PRIMARY);
    }

    public Content putRepomd(String repoLocation, Payload payload, OffsetDateTime rebuildTime, int rpmCount, boolean hasComps) {
        Preconditions.checkNotNull((Object)repoLocation);
        Preconditions.checkArgument((repoLocation.startsWith(PATH_PREFIX) && repoLocation.endsWith(PATH_PREFIX) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)payload);
        Preconditions.checkNotNull((Object)rebuildTime);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, YumMetadataUtils.HASH_ALGORITHMS);){
            String assetPath = String.valueOf(repoLocation) + "repodata/repomd.xml";
            ImmutableMap yumAttr = ImmutableMap.of((Object)REBUILT_START_TIME_KEY, (Object)rebuildTime.toString(), (Object)RPM_COUNT, (Object)rpmCount, (Object)HAS_COMPS, (Object)hasComps);
            FluentAsset asset = this.prepareMetadataAsset(assetPath, YumMetadataType.REPOMD.getKind()).blob(tempBlob).attributes("yum", (Object)yumAttr).save();
            asset.attributes(AttributeOperation.OVERLAY, "yum", (Object)ImmutableMap.of((Object)REBUILT_START_TIME_KEY, (Object)rebuildTime.toString(), (Object)RPM_COUNT, (Object)rpmCount, (Object)HAS_COMPS, (Object)hasComps));
            return asset.markAsCached(payload).download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content putMetadata(String repoLocation, Payload payload, YumMetadataType type) {
        Preconditions.checkNotNull((Object)repoLocation);
        Preconditions.checkNotNull((Object)payload);
        Preconditions.checkArgument((repoLocation.startsWith(PATH_PREFIX) && repoLocation.endsWith(PATH_PREFIX) ? 1 : 0) != 0);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, YumMetadataUtils.HASH_ALGORITHMS);){
            String assetPath = String.valueOf(repoLocation) + "repodata/" + tempBlob.getHashes().get(HashAlgorithm.SHA256) + "-" + type.getType() + "." + type.getFileType();
            return this.prepareMetadataAsset(assetPath, type.getKind()).blob(tempBlob).save().markAsCached(payload).download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected WritePolicy writePolicy(Asset asset) {
        WritePolicy writePolicy = super.writePolicy(asset);
        if (WritePolicy.ALLOW_ONCE == writePolicy) {
            String kind = asset.kind();
            if (!Objects.equals(AssetKind.RPM.name(), kind)) {
                return WritePolicy.ALLOW;
            }
        }
        return writePolicy;
    }

    public Optional<FluentAsset> get(String assetPath) {
        return this.assets().path(assetPath).find();
    }

    public Iterable<FluentAsset> get(AssetKind assetKind) {
        return Continuations.iterableOf((arg_0, arg_1) -> ((FluentQuery)this.assets().byKind(assetKind.name())).browse(arg_0, arg_1));
    }

    public Iterable<FluentAsset> get() {
        return Continuations.iterableOf((arg_0, arg_1) -> ((FluentAssets)this.assets()).browse(arg_0, arg_1));
    }

    public Optional<FluentAsset> findComps(String repoLocation) {
        return this.assets().byFilter("kind = #{filterParams.kind} AND path LIKE #{filterParams.path}", (Map)ImmutableMap.of((Object)"kind", (Object)AssetKind.COMPS.toString(), (Object)"path", (Object)(String.valueOf(repoLocation) + '%'))).browse(1, null).stream().findFirst();
    }

    public Content putHardLink(String assetPath, Blob blob, Map<HashAlgorithm, HashCode> checksums, AssetKind assetKind) {
        if (assetKind == AssetKind.RPM) {
            return this.putRPMHardLink(assetPath, blob, checksums);
        }
        return this.putMetadataHardLink(assetPath, blob, checksums, assetKind).download();
    }

    public Content putRPMHardLink(String assetPath, Blob blob, Map<HashAlgorithm, HashCode> checksums) {
        YumRpm yumRpm = this.parse(blob, assetPath);
        FluentComponent fluentComponent = this.getOrCreateRpmComponent(yumRpm);
        Content content = this.prepareRpmAsset(assetPath, yumRpm, fluentComponent).blob(blob, checksums).save().download();
        content.getAttributes().set(YumRpm.class, (Object)yumRpm);
        return content;
    }

    private FluentAsset putMetadataHardLink(String assetPath, Blob blob, Map<HashAlgorithm, HashCode> checksums, AssetKind assetKind) {
        FluentAssetBuilder fluentAssetBuilder = this.prepareMetadataAsset(assetPath, assetKind);
        return fluentAssetBuilder.blob(blob, checksums).save();
    }

    public Content put(String assetPath, Payload payload, AssetKind assetKind) {
        if (assetKind == AssetKind.RPM) {
            return this.putRPM(assetPath, payload);
        }
        return this.putMetadata(assetPath, payload, assetKind);
    }

    public Content putRPM(String assetPath, Payload payload) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, YumMetadataUtils.HASH_ALGORITHMS);){
            YumRpm yumRpm = this.parse(tempBlob.getBlob(), assetPath);
            FluentComponent fluentComponent = this.getOrCreateRpmComponent(yumRpm);
            FluentAsset asset = this.prepareRpmAsset(assetPath, yumRpm, fluentComponent).blob(tempBlob).save();
            Content result = asset.markAsCached(payload).download();
            result.getAttributes().set(YumRpm.class, (Object)yumRpm);
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content putMetadata(String assetPath, Payload payload, AssetKind assetKind) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, YumMetadataUtils.HASH_ALGORITHMS);){
            FluentAssetBuilder fluentAssetBuilder = this.prepareMetadataAsset(assetPath, assetKind);
            FluentAsset asset = fluentAssetBuilder.blob(tempBlob).save();
            return asset.markAsCached(payload).download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private FluentComponent getOrCreateRpmComponent(YumRpm yumRpm) {
        Map<String, Object> componentFormatAttributes = this.componentAttributePopulator.extractComponentAttributes(yumRpm);
        String componentName = yumRpm.getName();
        String componentVersion = yumRpm.getFullVersion();
        return this.components().name(componentName).version(componentVersion).normalizedVersion(this.versionNormalizerService().getNormalizedVersionByFormat(componentVersion, this.repository().getFormat())).attributes("yum", componentFormatAttributes).getOrCreate();
    }

    private FluentAssetBuilder prepareRpmAsset(String assetPath, YumRpm yumRpm, FluentComponent component) {
        Map<String, Object> assetFormatAttributes = this.assetAttributePopulator.extractAssetAttributes(yumRpm);
        assetFormatAttributes.put("asset_kind", AssetKind.RPM.name());
        return this.assets().path(assetPath).kind(AssetKind.RPM.name()).component((Component)component).attributes("yum", assetFormatAttributes);
    }

    private FluentAssetBuilder prepareMetadataAsset(String assetPath, AssetKind assetKind) {
        return this.assets().path(assetPath).kind(assetKind.name()).attributes("yum", Collections.singletonMap("asset_kind", assetKind.name()));
    }

    private YumRpm parse(Blob blob, String assetPath) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = blob.getInputStream();){
                return this.rpmParser.parse(inputStream, StringUtils.prependIfMissing((String)assetPath, (CharSequence)PATH_PREFIX, (CharSequence[])new CharSequence[0]));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public TempBlob ingest(Payload payload, Iterable<HashAlgorithm> hashing) {
        return this.blobs().ingest(payload, hashing);
    }

    public TempBlob ingest(InputStream is, @Nullable String contentType, Iterable<HashAlgorithm> hashing) {
        return this.blobs().ingest(is, contentType, hashing);
    }
}

