/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonatype.nexus.blobstore.restore.internal.orient.YumRestoreBlobData;
import com.sonatype.nexus.blobstore.restore.internal.orient.YumRestoreBlobDataFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.blobstore.restore.orient.OrientBaseRestoreBlobStrategy;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.orient.OrientYumFacet;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;

@Named(value="yum")
@Singleton
public class OrientYumRestoreBlobStrategy
extends OrientBaseRestoreBlobStrategy<YumRestoreBlobData> {
    final YumRestoreBlobDataFactory yumRestoreBlobDataFactory;

    @Inject
    public OrientYumRestoreBlobStrategy(RepositoryManager repositoryManager, NodeAccess nodeAccess, DryRunPrefix dryRunPrefix, YumRestoreBlobDataFactory yumRestoreBlobDataFactory) {
        super(nodeAccess, repositoryManager, dryRunPrefix);
        this.yumRestoreBlobDataFactory = (YumRestoreBlobDataFactory)Preconditions.checkNotNull((Object)yumRestoreBlobDataFactory);
    }

    protected YumRestoreBlobData createRestoreData(RestoreBlobData blobData) {
        return this.yumRestoreBlobDataFactory.create(blobData);
    }

    protected boolean canAttemptRestore(@Nonnull YumRestoreBlobData data) {
        Repository repository = data.getBlobData().getRepository();
        Optional yumFacet = repository.optionalFacet(OrientYumFacet.class);
        if (!yumFacet.isPresent()) {
            this.log.warn("Skipping as Yum Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected String getAssetPath(@Nonnull YumRestoreBlobData data) {
        return data.getPath();
    }

    protected boolean assetExists(@Nonnull YumRestoreBlobData data) throws IOException {
        OrientYumFacet yumFacet = (OrientYumFacet)data.getBlobData().getRepository().facet(OrientYumFacet.class);
        return yumFacet.getAsset(data.getBlobData().getBlobName()) != null;
    }

    protected void createAssetFromBlob(@Nonnull AssetBlob assetBlob, @Nonnull YumRestoreBlobData data) throws IOException {
        OrientYumFacet yumFacet = (OrientYumFacet)data.getBlobData().getRepository().facet(OrientYumFacet.class);
        switch (data.getAssetKind()) {
            case RPM: {
                yumFacet.storeRpm(data.getPath(), assetBlob, new AttributesMap());
                break;
            }
            case REPOMD: 
            case REPOMD_ASC: 
            case REPODATA: 
            case COMPS: 
            case NON_YUM: {
                yumFacet.storeMetadata(data.getPath(), assetBlob, data.getAssetKind(), new AttributesMap());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected boolean componentRequired(YumRestoreBlobData data) {
        return data.getAssetKind() == AssetKind.RPM;
    }

    protected Repository getRepository(@Nonnull YumRestoreBlobData data) {
        return data.getBlobData().getRepository();
    }

    protected Query getComponentQuery(YumRestoreBlobData data) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = data.getBlobData().getBlob().getInputStream();){
            String version = YumPathUtils.extractFullVersion(data.getPath(), inputStream);
            return Query.builder().where("name").eq((Object)data.getPath()).and("version").eq((Object)version).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Nonnull
    protected List<HashAlgorithm> getHashAlgorithms() {
        return Lists.newArrayList((Object[])new HashAlgorithm[]{HashAlgorithm.SHA1, HashAlgorithm.SHA256, HashAlgorithm.SHA512, HashAlgorithm.MD5});
    }
}

