/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BeanLocator;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.datastore.DataStoreConfigurationManager;
import org.sonatype.nexus.datastore.DataStoreDescriptor;
import org.sonatype.nexus.datastore.DataStoreRestorer;
import org.sonatype.nexus.datastore.DataStoreUsageChecker;
import org.sonatype.nexus.datastore.api.DataAccess;
import org.sonatype.nexus.datastore.api.DataSession;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.datastore.api.DataStore;
import org.sonatype.nexus.datastore.api.DataStoreConfiguration;
import org.sonatype.nexus.datastore.api.DataStoreManager;
import org.sonatype.nexus.datastore.api.DataStoreNotFoundException;
import org.sonatype.nexus.distributed.event.service.api.common.DataStoreConfigurationEvent;
import org.sonatype.nexus.jmx.reflect.ManagedObject;
import org.sonatype.nexus.transaction.TransactionIsolation;

@Named
@Singleton
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.STORAGE)
@ManagedObject
public class DataStoreManagerImpl
extends StateGuardLifecycleSupport
implements DataStoreManager,
DataSessionSupplier {
    private static final Key<Class<DataAccess>> DATA_ACCESS_KEY = new Key<Class<DataAccess>>(){};
    private static final DataAccessMediator DATA_ACCESS_MEDIATOR = new DataAccessMediator();
    private final boolean enabled;
    private final Map<String, DataStoreDescriptor> dataStoreDescriptors;
    private final Map<String, Provider<DataStore<?>>> dataStorePrototypes;
    private final DataStoreConfigurationManager configurationManager;
    private final Provider<DataStoreUsageChecker> usageChecker;
    private final BeanLocator beanLocator;
    private final Map<String, DataStore<?>> dataStores = new ConcurrentHashMap();
    private final DataStoreRestorer restorer;
    private final EventManager eventManager;
    private volatile boolean frozen;

    @Inject
    public DataStoreManagerImpl(@Named(value="${nexus.datastore.enabled:-false}") @Named(value="${nexus.datastore.enabled:-false}") boolean enabled, EventManager eventManager, Map<String, DataStoreDescriptor> dataStoreDescriptors, Map<String, Provider<DataStore<?>>> dataStorePrototypes, DataStoreConfigurationManager configurationManager, Provider<DataStoreUsageChecker> usageChecker, DataStoreRestorer restorer, BeanLocator beanLocator) {
        this.enabled = enabled;
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.dataStoreDescriptors = (Map)Preconditions.checkNotNull(dataStoreDescriptors);
        this.dataStorePrototypes = (Map)Preconditions.checkNotNull(dataStorePrototypes);
        this.configurationManager = (DataStoreConfigurationManager)((Object)Preconditions.checkNotNull((Object)((Object)configurationManager)));
        this.usageChecker = (Provider)Preconditions.checkNotNull(usageChecker);
        this.beanLocator = (BeanLocator)Preconditions.checkNotNull((Object)beanLocator);
        this.restorer = (DataStoreRestorer)Preconditions.checkNotNull((Object)restorer);
    }

    protected void doStart() throws Exception {
        if (this.enabled) {
            this.configurationManager.load().forEach(this::tryRestore);
        }
    }

    protected void doStop() throws Exception {
        for (DataStore<?> store : this.browse()) {
            try {
                this.log.debug("Shutting down {}", store);
                store.shutdown();
                this.log.debug("Shut down {}", store);
            }
            catch (Exception e) {
                this.log.warn("Problem shutting down {}", store, (Object)e);
            }
        }
        this.dataStores.clear();
    }

    public DataSession<?> openSession(String storeName) {
        return (DataSession)this.get(storeName).orElseThrow(() -> new DataStoreNotFoundException(storeName)).openSession();
    }

    public DataSession<?> openSerializableTransactionSession(String storeName) {
        return (DataSession)this.get(storeName).orElseThrow(() -> new DataStoreNotFoundException(storeName)).openSession(TransactionIsolation.SERIALIZABLE);
    }

    public Connection openConnection(String storeName) throws SQLException {
        return this.get(storeName).orElseThrow(() -> new DataStoreNotFoundException(storeName)).openConnection();
    }

    public Iterable<DataStore<?>> browse() {
        return this.dataStores.values();
    }

    @Guarded(by={"STARTED"})
    public DataStore<?> create(DataStoreConfiguration configuration) throws Exception {
        Preconditions.checkState((boolean)this.enabled, (Object)"Datastore feature is not enabled");
        return this.doCreate(configuration);
    }

    private void tryRestore(DataStoreConfiguration configuration) {
        try {
            this.restorer.maybeRestore(configuration);
            this.doCreate(configuration);
        }
        catch (Exception e) {
            this.log.warn("Problem restoring {}", (Object)configuration, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStore<?> doCreate(DataStoreConfiguration configuration) throws Exception {
        Preconditions.checkNotNull((Object)configuration);
        String storeName = configuration.getName();
        Preconditions.checkState((!this.exists(storeName) ? 1 : 0) != 0, (String)"%s data store already exists", (Object)storeName);
        this.validateConfiguration(configuration);
        this.configurationManager.save(configuration);
        DataStore<?> store = this.createDataStore(configuration);
        this.log.debug("Starting {}", store);
        store.start();
        this.beanLocator.watch(DATA_ACCESS_KEY, (Mediator)DATA_ACCESS_MEDIATOR, store);
        Map<String, DataStore<?>> map = this.dataStores;
        synchronized (map) {
            if (this.frozen) {
                store.freeze();
            }
            if (this.dataStores.putIfAbsent(Strings2.lower((String)storeName), store) != null) {
                this.log.debug("Stopping duplicate {}", store);
                store.stop();
                throw new IllegalStateException("Duplicate request to create " + storeName + " data store");
            }
        }
        this.log.debug("Started {}", store);
        return store;
    }

    @Guarded(by={"STARTED"})
    public DataStore<?> update(DataStoreConfiguration newConfiguration) throws Exception {
        Preconditions.checkNotNull((Object)newConfiguration);
        String storeName = newConfiguration.getName();
        Preconditions.checkState((boolean)this.exists(storeName), (String)"%s data store does not exist", (Object)storeName);
        this.validateConfiguration(newConfiguration);
        this.configurationManager.save(newConfiguration);
        DataStore<?> store = this.get(storeName).get();
        Preconditions.checkState((store != null ? 1 : 0) != 0, (String)"%s data store has been removed", (Object)storeName);
        DataStoreConfiguration oldConfiguration = store.getConfiguration();
        if (store.isStarted()) {
            this.log.debug("Stopping {} for reconfiguration", store);
            store.stop();
        }
        Exception updateFailure = null;
        try {
            store.setConfiguration(newConfiguration);
            this.log.debug("Restarting {}", store);
            store.start();
        }
        catch (Exception e) {
            updateFailure = e;
            this.log.warn("Problem restarting {}", store, (Object)e);
            this.configurationManager.save(oldConfiguration);
            if (store.isStarted()) {
                this.log.debug("Stopping {} to revert changes", store);
                store.stop();
            }
            store.setConfiguration(oldConfiguration);
            this.log.debug("Restarting {}", store);
            store.start();
        }
        this.log.debug("Restarted {}", store);
        if (updateFailure != null) {
            throw new IllegalArgumentException("Configuration update failed for " + storeName, updateFailure);
        }
        if (!EventHelper.isReplicating()) {
            this.eventManager.post((Object)new DataStoreConfigurationEvent(newConfiguration.getName(), newConfiguration.getType(), newConfiguration.getSource(), newConfiguration.getAttributes()));
        }
        return store;
    }

    @Guarded(by={"STARTED"})
    public Optional<DataStore<?>> get(String storeName) {
        Preconditions.checkNotNull((Object)storeName);
        return Optional.ofNullable(this.dataStores.get(Strings2.lower((String)storeName)));
    }

    @Guarded(by={"STARTED"})
    public boolean delete(String storeName) throws Exception {
        Preconditions.checkNotNull((Object)storeName);
        Preconditions.checkState((!((DataStoreUsageChecker)this.usageChecker.get()).isDataStoreUsed(storeName) ? 1 : 0) != 0, (String)"%s data store is in use by at least one repository", (Object)storeName);
        DataStore<?> store = this.dataStores.remove(Strings2.lower((String)storeName));
        if (store != null) {
            try {
                this.log.debug("Shutting down {} for deletion", store);
                store.shutdown();
                this.log.debug("Shut down {}", store);
            }
            finally {
                this.configurationManager.delete(store.getConfiguration());
            }
        }
        return store != null;
    }

    public boolean exists(String storeName) {
        Preconditions.checkNotNull((Object)storeName);
        return this.dataStores.containsKey(Strings2.lower((String)storeName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeze() {
        Map<String, DataStore<?>> map = this.dataStores;
        synchronized (map) {
            this.frozen = true;
            this.browse().forEach(DataStore::freeze);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unfreeze() {
        Map<String, DataStore<?>> map = this.dataStores;
        synchronized (map) {
            this.frozen = false;
            this.browse().forEach(DataStore::unfreeze);
        }
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    private void validateConfiguration(DataStoreConfiguration configuration) {
        String storeType = configuration.getType();
        DataStoreDescriptor descriptor = this.dataStoreDescriptors.get(storeType);
        Preconditions.checkState((descriptor != null ? 1 : 0) != 0, (String)"Missing data store descriptor '%s'", (Object)storeType);
        Preconditions.checkState((boolean)descriptor.isEnabled(), (String)"Data store type '%s' is not enabled", (Object)storeType);
        descriptor.validate(configuration);
    }

    private DataStore<?> createDataStore(DataStoreConfiguration configuration) {
        String storeType = configuration.getType();
        Provider<DataStore<?>> prototype = this.dataStorePrototypes.get(storeType);
        Preconditions.checkState((prototype != null ? 1 : 0) != 0, (String)"Missing data store prototype '%s'", (Object)storeType);
        DataStore store = (DataStore)prototype.get();
        store.setConfiguration(configuration);
        return store;
    }

    private static class DataAccessMediator
    implements Mediator<Named, Class<DataAccess>, DataStore<?>> {
        private DataAccessMediator() {
        }

        public void add(BeanEntry<Named, Class<DataAccess>> entry, DataStore<?> store) {
            store.register((Class)entry.getValue());
        }

        public void remove(BeanEntry<Named, Class<DataAccess>> entry, DataStore<?> store) {
            store.unregister((Class)entry.getValue());
        }
    }
}

