/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore;

import com.google.common.base.Preconditions;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.datastore.api.DataSession;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.transaction.TransactionIsolation;
import org.sonatype.nexus.transaction.TransactionalStore;

public abstract class TransactionalStoreSupport
extends StateGuardLifecycleSupport
implements TransactionalStore<DataSession<?>> {
    protected final DataSessionSupplier sessionSupplier;
    private final String storeName;

    protected TransactionalStoreSupport(DataSessionSupplier sessionSupplier, String storeName) {
        this.sessionSupplier = (DataSessionSupplier)Preconditions.checkNotNull((Object)sessionSupplier);
        this.storeName = (String)Preconditions.checkNotNull((Object)storeName);
    }

    public DataSession<?> openSession() {
        return this.sessionSupplier.openSession(this.storeName);
    }

    public DataSession<?> openSession(TransactionIsolation isolationLevel) {
        switch (isolationLevel) {
            case SERIALIZABLE: {
                this.log.debug("Opening session with serializable transaction isolation");
                return this.sessionSupplier.openSerializableTransactionSession(this.storeName);
            }
        }
        return this.sessionSupplier.openSession(this.storeName);
    }
}

