/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Map;
import java.util.stream.Collectors;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.SingleResponseValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.common.stateguard.Transitions;
import org.sonatype.nexus.datastore.api.DataSession;
import org.sonatype.nexus.datastore.api.DataStore;
import org.sonatype.nexus.datastore.api.DataStoreConfiguration;

public abstract class DataStoreSupport<S extends DataSession<?>>
extends StateGuardLifecycleSupport
implements DataStore<S> {
    protected DataStoreConfiguration configuration;
    private String storeName;

    public DataStoreConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DataStoreConfiguration configuration) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)configuration.getName()) ? 1 : 0) != 0);
        this.configuration = configuration;
        this.storeName = configuration.getName();
    }

    protected final void doStart() throws Exception {
        this.doStart(this.storeName, this.interpolatedAttributes());
    }

    protected abstract void doStart(String var1, Map<String, String> var2) throws Exception;

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "configuration=" + this.configuration + '}';
    }

    protected void warn(String format, Object ... args) {
        this.log.warn(this.inStore(format), args);
    }

    protected void info(String format, Object ... args) {
        this.log.info(this.inStore(format), args);
    }

    protected void debug(String format, Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.inStore(format), args);
        }
    }

    private String inStore(String message) {
        return String.valueOf(this.storeName) + " - " + message;
    }

    private Map<String, String> interpolatedAttributes() throws Exception {
        Map attributes = this.configuration.getAttributes();
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.addValueSource((ValueSource)new SingleResponseValueSource("storeName", (Object)this.storeName));
        interpolator.addValueSource((ValueSource)new MapBasedValueSource(attributes));
        interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)System.getProperties()));
        interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
        return attributes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, arg_0 -> DataStoreSupport.lambda$1((Interpolator)interpolator, arg_0)));
    }

    @Transitions(to="SHUTDOWN")
    public void shutdown() throws Exception {
        if (this.isStarted()) {
            this.doStop();
        }
    }

    private static /* synthetic */ String lambda$1(Interpolator interpolator, Map.Entry entry) {
        try {
            return interpolator.interpolate((String)entry.getValue());
        }
        catch (InterpolationException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

