/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.distributed.event.service.api.common.DataStoreConfigurationEvent;

@Named
@Singleton
public class DataStoreAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "DataStore";

    public DataStoreAuditor() {
        this.registerType(DataStoreConfigurationEvent.class, "updated");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(DataStoreConfigurationEvent event) {
        if (this.isRecording()) {
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType(this.type(event.getClass()));
            data.setContext(event.getConfigurationName());
            Map attributes = data.getAttributes();
            attributes.put("type", event.getType());
            attributes.put("source", event.getSource());
            HashMap<String, String> eventAttributes = new HashMap<String, String>(event.getAttributes());
            eventAttributes.replace("password", "**REDACTED**");
            attributes.put("attributes", eventAttributes);
            this.record(data);
        }
    }
}

