/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore;

import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.eclipse.sisu.inject.TypeArguments;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.datastore.TransactionalStoreSupport;
import org.sonatype.nexus.datastore.api.DataAccess;
import org.sonatype.nexus.datastore.api.DataSession;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.transaction.UnitOfWork;

public abstract class ConfigStoreSupport<T extends DataAccess>
extends TransactionalStoreSupport {
    private final Class<T> daoClass;
    private EventManager eventManager;

    protected ConfigStoreSupport(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier, "nexus");
        TypeLiteral superType = TypeLiteral.get(((Object)((Object)this)).getClass()).getSupertype(ConfigStoreSupport.class);
        this.daoClass = TypeArguments.get((TypeLiteral)superType, (int)0).getRawType();
    }

    @Inject
    protected void setDependencies(EventManager eventManager) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    public void postCommitEvent(Supplier<?> eventSupplier) {
        this.thisSession().postCommit(() -> this.postEvent(eventSupplier));
    }

    private void postEvent(Supplier<?> eventSupplier) {
        this.eventManager.post(eventSupplier.get());
    }

    protected ConfigStoreSupport(DataSessionSupplier sessionSupplier, Class<T> daoClass) {
        super(sessionSupplier, "nexus");
        this.daoClass = (Class)Preconditions.checkNotNull(daoClass);
    }

    protected DataSession<?> thisSession() {
        return (DataSession)UnitOfWork.currentSession();
    }

    protected T dao() {
        return (T)this.thisSession().access(this.daoClass);
    }
}

