/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.commands.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import java.util.Iterator;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.inject.BeanLocator;
import org.sonatype.nexus.commands.CommandSupport;
import org.sonatype.nexus.commands.SessionAware;

public class BeanEntryCommand
extends CommandSupport {
    private final BeanLocator beanLocator;
    private final BeanEntry<?, Action> beanEntry;

    public BeanEntryCommand(BeanLocator beanLocator, BeanEntry<?, Action> beanEntry) {
        super(beanEntry.getImplementationClass());
        this.beanLocator = (BeanLocator)Preconditions.checkNotNull((Object)beanLocator);
        this.beanEntry = (BeanEntry)Preconditions.checkNotNull(beanEntry);
    }

    @Override
    protected Completer getCompleter(Class<?> clazz) {
        Iterator itr = this.beanLocator.locate(Key.get(clazz)).iterator();
        if (itr.hasNext()) {
            return (Completer)((BeanEntry)itr.next()).getValue();
        }
        return super.getCompleter(clazz);
    }

    @Override
    protected Action createNewAction(Session session) {
        Action action = (Action)this.beanEntry.getProvider().get();
        if (action instanceof SessionAware) {
            ((SessionAware)action).setSession(session);
        }
        return action;
    }

    @Override
    protected void releaseAction(Action action) {
    }

    public String toString() {
        return this.beanEntry.toString();
    }

    public int hashCode() {
        return this.beanEntry.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BeanEntryCommand) {
            return this.beanEntry.equals(((BeanEntryCommand)obj).beanEntry);
        }
        return false;
    }
}

