/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.commands.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.EagerSingleton;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BeanLocator;
import org.osgi.framework.BundleContext;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.commands.internal.BeanEntryCommand;

@Named
@EagerSingleton
public class ActionRegistrar
extends ComponentSupport {
    private final BeanLocator beanLocator;
    private final SessionFactory sessionFactory;

    @Inject
    public ActionRegistrar(BeanLocator beanLocator, @Nullable SessionFactory sessionFactory, @Nullable BundleContext bundleContext) {
        this.beanLocator = (BeanLocator)Preconditions.checkNotNull((Object)beanLocator);
        this.sessionFactory = sessionFactory;
        if (bundleContext != null) {
            beanLocator.watch(Key.get(Action.class, Named.class), (Mediator)new ActionMediator(), (Object)bundleContext);
        } else {
            this.log.warn("BundleContext is not available, unable to watch action components for registration");
        }
    }

    private class ActionMediator
    implements Mediator<Named, Action, BundleContext> {
        private ActionMediator() {
        }

        public void add(BeanEntry<Named, Action> beanEntry, BundleContext bundleContext) throws Exception {
            Command command = beanEntry.getImplementationClass().getAnnotation(Command.class);
            if (command != null) {
                ActionRegistrar.this.log.debug("Registering command: {}", beanEntry);
                ActionRegistrar.this.sessionFactory.getRegistry().register((Object)new BeanEntryCommand(ActionRegistrar.this.beanLocator, beanEntry));
            } else {
                ActionRegistrar.this.log.warn("Missing @Command annotation on action: {}", beanEntry);
            }
        }

        public void remove(BeanEntry<Named, Action> beanEntry, BundleContext bundleContext) throws Exception {
            Command command = beanEntry.getImplementationClass().getAnnotation(Command.class);
            if (command != null) {
                ActionRegistrar.this.log.debug("Unregistering command: {}", beanEntry);
                ActionRegistrar.this.sessionFactory.getRegistry().unregister((Object)new BeanEntryCommand(ActionRegistrar.this.beanLocator, beanEntry));
            }
        }
    }
}

