/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability.internal;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.nexus.capability.Capability;
import org.sonatype.nexus.capability.CapabilityIdentity;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.internal.CapabilityDTO;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.rest.Resource;

@FeatureFlag(name="nexus.internal.ha.tests")
@Named
@Singleton
@Path(value="internal/capabilities")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CapabilityResource
implements Resource {
    static final String PASSWORD_PLACEHOLDER = "#~NXRM~PLACEHOLDER~PASSWORD~#";
    static final String RESOURCE_URI = "internal/capabilities";
    private final CapabilityRegistry registry;

    @Inject
    public CapabilityResource(CapabilityRegistry registry) {
        this.registry = (CapabilityRegistry)Preconditions.checkNotNull((Object)registry);
    }

    @GET
    @RequiresPermissions(value={"nexus:capabilities:read"})
    public Collection<CapabilityDTO> list() {
        return this.registry.getAll().stream().map(CapabilityDTO::new).collect(Collectors.toList());
    }

    @GET
    @Path(value="active")
    @RequiresPermissions(value={"nexus:capabilities:read"})
    public Collection<CapabilityDTO> listActive() {
        return this.registry.getAll().stream().map(CapabilityDTO::new).collect(Collectors.toList());
    }

    @POST
    @RequiresPermissions(value={"nexus:capabilities:create"})
    public CapabilityDTO create(CapabilityDTO capability) {
        return new CapabilityDTO(this.registry.add(CapabilityType.capabilityType(capability.getType()), capability.isEnabled(), capability.getNotes(), capability.getProperties()));
    }

    @PUT
    @Path(value="{capabilityId}")
    @RequiresPermissions(value={"nexus:capabilities:update"})
    public void update(@PathParam(value="capabilityId") String capabilityId, CapabilityDTO capabilityDto) {
        CapabilityReference reference = this.registry.get(CapabilityIdentity.capabilityIdentity(capabilityId));
        this.registry.update(CapabilityIdentity.capabilityIdentity(capabilityDto.getId()), capabilityDto.isEnabled(), capabilityDto.getNotes(), CapabilityResource.unfilterProperties(capabilityDto.getProperties(), reference.context().properties()));
    }

    @DELETE
    @Path(value="{capabilityId}")
    @RequiresPermissions(value={"nexus:capabilities:delete"})
    public void delete(@PathParam(value="capabilityId") String capabilityId) {
        this.registry.remove(CapabilityIdentity.capabilityIdentity(capabilityId));
    }

    private static Map<String, String> unfilterProperties(Map<String, String> properties, Map<String, String> referenceProperties) {
        return properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            if (PASSWORD_PLACEHOLDER.equals(entry.getValue())) {
                return (String)referenceProperties.get(entry.getKey());
            }
            return (String)entry.getValue();
        }));
    }

    static Map<String, String> filterProperties(Map<String, String> properties, Capability capability) {
        return properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            if (capability.isPasswordProperty((String)entry.getKey())) {
                if ("PKI".equals(properties.get("authenticationType"))) {
                    return "";
                }
                return PASSWORD_PLACEHOLDER;
            }
            return (String)entry.getValue();
        }));
    }
}

