/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.sonatype.nexus.capability.CapabilityContext;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.internal.CapabilityResource;

public class CapabilityDTO {
    private String id;
    private String type;
    private String notes;
    private boolean enabled;
    private Map<String, String> properties;

    protected CapabilityDTO() {
    }

    public CapabilityDTO(CapabilityReference reference) {
        Preconditions.checkNotNull((Object)reference);
        CapabilityContext context = (CapabilityContext)Preconditions.checkNotNull((Object)reference.context());
        this.id = context.id().toString();
        this.type = context.type().toString();
        this.enabled = context.isEnabled();
        this.notes = context.notes();
        this.properties = CapabilityResource.filterProperties(context.properties(), reference.capability());
    }

    public String getId() {
        return this.id;
    }

    public String getNotes() {
        return this.notes;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getType() {
        return this.type;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setType(String type) {
        this.type = type;
    }
}

